package org.eclipse.swt.internal.photon;

/*
 * Copyright (c) 2000, 2002 IBM Corp.  All rights reserved.
 * This file is made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 */
 
import org.eclipse.swt.internal.*;

public class OS {

	/* Load the SWT library. */
	static {
		Library.loadLibrary ("swt");
	}

/**** BEGIN MANUALLY ADDED/FIXED ***/
	public static final int Pt_SET_DRAW_F										= 1507348;
	public static final int Pt_ARG_ORIENTATION                                    = ( 21 * 1000 + 5 );
	public static final int Pt_ARG_MAXIMUM                                        = ( 21 * 1000 + 3 );
	public static final int Pt_ARG_MINIMUM                                        = ( 21 * 1000 + 2 );
	public static final int Pt_ARG_WIDTH                                        = ( 1 * 1000 + 23 );
	public static final int Pt_ARG_HEIGHT                                        = ( 1 * 1000 + 24 );
//	public static final int Pt_ARG_STYLE                                        = ( 2 * 1000 + 18 );
	public static final int Ph_USE_TRANSPARENCY                                   = 0x80;
	public static final int Ph_RELEASE_IMAGE_ALL                                  = 0x1F;
	
	public static final int  Pt_TOP_ETCH				= 0x00000001;
	public static final int  Pt_BOTTOM_ETCH				= 0x00000002;
	public static final int  Pt_LEFT_ETCH				= 0x00000004;
	public static final int  Pt_RIGHT_ETCH				= 0x00000008;
	public static final int  Pt_TOP_OUTLINE				= 0x00000010;
	public static final int  Pt_BOTTOM_OUTLINE			= 0x00000020;
	public static final int  Pt_LEFT_OUTLINE			= 0x00000040;
	public static final int  Pt_RIGHT_OUTLINE			= 0x00000080;
	public static final int  Pt_TOP_BEVEL				= 0x00000100;
	public static final int  Pt_BOTTOM_BEVEL			= 0x00000200;
	public static final int  Pt_LEFT_BEVEL				= 0x00000400;
	public static final int  Pt_RIGHT_BEVEL				= 0x00000800;
	public static final int  Pt_TOP_INLINE				= 0x00001000;
	public static final int  Pt_BOTTOM_INLINE			= 0x00002000;
	public static final int  Pt_LEFT_INLINE				= 0x00004000;
	public static final int  Pt_RIGHT_INLINE			= 0x00008000;
	public static final int  Pt_FLAT_FILL				= 0x00010000;
//	public static final int  Pt_FULL_BORDERS			= 0x00020000;
//	public static final int  Pt_FULL_BEVELS				= 0x00020000;
	public static final int  Pt_HORIZONTAL_GRADIENT		= 0x00040000;
//	public static final int  Pt_REVERSE_GRADIENT		= 0x00080000;
	public static final int  Pt_STATIC_GRADIENT			= 0x00100000;
//	public static final int  Pt_STATIC_BORDERS			= 0x00200000;
//	public static final int  Pt_STATIC_BEVELS			= 0x00200000;
//	public static final int  Pt_STATIC_BORDER_COLORS	= 0x00400000;
//	public static final int  Pt_STATIC_BEVEL_COLORS		= 0x00400000;
//	public static final int  Pt_BASIC_ARMED				= 0x80000000;
//	public static final int  Pt_BASIC_RO_FLAGS			= 0x80000000;
//	public static final int  Pt_TOP_LEFT_ETCH			= (Pt_TOP_ETCH | Pt_LEFT_ETCH);
//	public static final int  Pt_BOTTOM_RIGHT_ETCH		= (Pt_BOTTOM_ETCH | Pt_RIGHT_ETCH);
//	public static final int  Pt_ALL_ETCHED 				= (Pt_TOP_LEFT_ETCH | Pt_BOTTOM_RIGHT_ETCH);
	public static final int  Pt_ALL_ETCHES				= (Pt_TOP_ETCH | Pt_BOTTOM_ETCH | Pt_LEFT_ETCH | Pt_RIGHT_ETCH );
//	public static final int  Pt_TOP_LEFT_OUTLINE		= (Pt_TOP_OUTLINE | Pt_LEFT_OUTLINE);
//	public static final int  Pt_BOTTOM_RIGHT_OUTLINE	= (Pt_BOTTOM_OUTLINE | Pt_RIGHT_OUTLINE );
	public static final int  Pt_ALL_OUTLINES			= (Pt_TOP_OUTLINE | Pt_BOTTOM_OUTLINE | Pt_LEFT_OUTLINE | Pt_RIGHT_OUTLINE);
//	public static final int  Pt_TOP_LEFT_INLINE			= (Pt_TOP_INLINE | Pt_LEFT_INLINE);
//	public static final int  Pt_BOTTOM_RIGHT_INLINE 	= (Pt_BOTTOM_INLINE | Pt_RIGHT_INLINE );
	public static final int  Pt_ALL_INLINES				= (Pt_TOP_INLINE | Pt_BOTTOM_INLINE | Pt_LEFT_INLINE | Pt_RIGHT_INLINE);
//	public static final int  Pt_TOP_LEFT_BEVEL			= (Pt_TOP_BEVEL | Pt_LEFT_BEVEL);
//	public static final int  Pt_BOTTOM_RIGHT_BEVEL 		= (Pt_BOTTOM_BEVEL | Pt_RIGHT_BEVEL );
	public static final int  Pt_ALL_BEVELS				= (Pt_TOP_BEVEL | Pt_BOTTOM_BEVEL | Pt_LEFT_BEVEL | Pt_RIGHT_BEVEL);
//	public static final int  Pt_ALL_TOP					= (Pt_TOP_ETCH | Pt_TOP_OUTLINE | Pt_TOP_BEVEL | Pt_TOP_INLINE);
//	public static final int  Pt_ALL_BOTTOM				= (Pt_BOTTOM_ETCH | Pt_BOTTOM_OUTLINE | Pt_BOTTOM_BEVEL | Pt_BOTTOM_INLINE);
//	public static final int  Pt_ALL_LEFT				= (Pt_LEFT_ETCH | Pt_LEFT_OUTLINE | Pt_LEFT_BEVEL | Pt_LEFT_INLINE);
//	public static final int  Pt_ALL_RIGHT				= (Pt_RIGHT_ETCH | Pt_RIGHT_OUTLINE | Pt_RIGHT_BEVEL | Pt_RIGHT_INLINE);
//	public static final int  Pt_ALL						= (Pt_ALL_TOP | Pt_ALL_BOTTOM | Pt_ALL_LEFT | Pt_ALL_RIGHT);

	public static final int NAME_MAX						= 255;
	public static final int PATH_MAX						= 1024;
	public static final int Pt_FSR_NO_FCHECK				= 0x000100;
//	public static final int Pt_FSR_NO_FSPEC					= 0x000200; 
//	public static final int Pt_FSR_NO_UP_BUTTON				= 0x000400;
//	public static final int Pt_FSR_NO_NEW					= 0x000800;
//	public static final int Pt_FSR_NO_NEW_BUTTON			= 0x001000;
	public static final int Pt_FSR_NO_SELECT_FILES			= 0x002000;
	public static final int Pt_FSR_SELECT_DIRS				= 0x004000;
//	public static final int Pt_FSR_CREATE_PATH				= 0x008000;
//	public static final int Pt_FSR_NO_CONFIRM_CREATE_PATH	= 0x010000;
//	public static final int Pt_FSR_NO_DELETE				= 0x020000;
//	public static final int Pt_FSR_NO_CONFIRM_DELETE		= 0x040000;
//	public static final int Pt_FSR_RECURSIVE_DELETE			= 0x080000;
//	public static final int Pt_FSR_CONFIRM_EXISTING  		= 0x100000;
//	public static final int Pt_FSR_CENTER					= 0x200000;
			
	public static final int Pt_ARG_BEVEL_WIDTH                                   = ( 1 * 1000 + 1 );
	public static final int Pt_ARG_INLINE_COLOR                                  = ( 2 * 1000 + 23 );
	public static final int Pt_ARG_OUTLINE_COLOR                                  = ( 2 * 1000 + 22 );
	public static final int Pt_ARG_LIGHT_FILL_COLOR                                  = ( 2 * 1000 + 24 );
	public static final int Pt_ARG_DARK_FILL_COLOR                                  = ( 2 * 1000 + 25 );
	public static final int Pt_ARG_DARK_BEVEL_COLOR                                  = ( 2 * 1000 + 6 );
	public static final int Pt_ARG_LIGHT_BEVEL_COLOR                                  = ( 2 * 1000 + 0 );
	public static final int Pt_ARG_BEVEL_COLOR                                  = ( 2 * 1000 + 21 );
	
	public static final int Pt_INDEX_COLOR                                  = 0x2000000;

//	public static final int Pg_ALPHA_VALID                                  = 0x80000000;
//	public static final int Pg_ALPHA_OP_TEST                                = 0x00010000;
//	public static final int Pg_ALPHA_OP_DEST_GLOBAL                         = 0x00020000;
	public static final int Pg_ALPHA_OP_SRC_GLOBAL                          = 0x00040000;
	public static final int Pg_ALPHA_OP_SRC_MAP                             = 0x00080000;
//	public static final int Pg_ALPHA_OP_SRC_GRADIENT                        = 0x00100000;
//	public static final int Pg_BLEND_SRC_ZERO                               = 0x0000;		// (0,0,0,0)
//	public static final int Pg_BLEND_SRC_ONE                                = 0x0100;		// (1,1,1,1)
//	public static final int Pg_BLEND_SRC_DST_COLOR                          = 0x0200;		// (Ad,Rd,Gd,Bd)
//	public static final int Pg_BLEND_SRC_ONE_MINUS_DST_ALPHA                = 0x0300;	// (1,1,1,1)-(Ad,Rd,Gd,Bd)
	public static final int Pg_BLEND_SRC_SRC_ALPHA                          = 0x0400;		// (As,As,As,As)
//	public static final int Pg_BLEND_SRC_ONE_MINUS_SRC_ALPHA                = 0x0500;	// (1,1,1,1)-(As,As,As,As)
//	public static final int Pg_BLEND_SRC_DST_ALPHA                          = 0x0600;		// (Ad,Ad,Ad,Ad)
//	public static final int Pg_BLEND_ONE_MINUS_DST_ALPHA                    = 0x0700;	    // (1,1,1,1)-(Ad,Ad,Ad,Ad)
//	public static final int Pg_BLEND_DST_ZERO                               = 0x00;		// (0,0,0,0)
//	public static final int Pg_BLEND_DST_ONE                                = 0x01;		// (1,1,1,1)
//	public static final int Pg_BLEND_DST_SRC_COLOR                          = 0x02;		// (As,Rs,Gs,Bs)
//	public static final int Pg_BLEND_DST_ONE_MINUS_SRC                      = 0x03;		// (1,1,1,1)-(As,Rs,Gs,Bs)
//	public static final int Pg_BLEND_DST_SRC_ALPHA                          = 0x04;		// (As,As,As,As)
	public static final int Pg_BLEND_DST_ONE_MINUS_SRC_ALPHA                = 0x05;		// (1,1,1,1)-(As,As,As,As)
//	public static final int Pg_BLEND_DST_DST_ALPHA                          = 0x06;		// (Ad,Ad,Ad,Ad)
//	public static final int Pg_BLEND_DST_ONE_MINUS_DST_ALPHA                = 0x07;		// (1,1,1,1)-(Ad,Ad,Ad,Ad)

//	public static final int Pg_GRAD_BYTES_PER_PIXEL = 3;
//	public static final int Pg_GRAD_IMAGE_TYPE  = Pg_IMAGE_DIRECT_888;
//	public static final int Pg_GRAD_BOXY        = 0x80000000;
//	public static final int Pg_GRAD_NOGRADIENT  = 0;
//	public static final int Pg_GRAD_VECTOR      = 1;
//	public static final int Pg_GRAD_RADIAL      = 2;
	public static final int Pg_GRAD_HORIZONTAL  = 3;
	public static final int Pg_GRAD_VERTICAL    = 4;
//	public static final int Pg_GRAD_FAST_VECTOR = 5;
//	public static final int Pg_GRAD_DIAGF       = 6;
//	public static final int Pg_GRAD_DIAGB       = 7;
//	public static final int Pg_GRAD_4POINT      = 8;
//	public static final int Pg_GRAD_BOX_DIAGF   = Pg_GRAD_DIAGF | Pg_GRAD_BOXY;
//	public static final int Pg_GRAD_BOX_DIAGB   = Pg_GRAD_DIAGB | Pg_GRAD_BOXY;
//	public static final int Pg_GRAD_BOX_4POINT  = Pg_GRAD_4POINT | Pg_GRAD_BOXY;
//	public static final int Pg_GRAD_TABLE       = 100;
	public static final int Pg_GRAD_LINEAR      = 0;
//	public static final int Pg_GRAD_HILL        = 1;
//	public static final int Pg_GRAD_HILL2       = 2;
//	public static final int Pg_GRAD_EXP         = 3;

//	public static final int Pt_ARG_PG_FLAGS		 			= 64 * 1000 + 0;
//	public static final int Pt_ARG_PG_CURRENT					= 64 * 1000 + 1;
	public static final int Pt_ARG_PG_PANEL_TITLES				= 64 * 1000 + 2;
//	public static final int Pt_ARG_PG_CONTAINERS				= 64 * 1000 + 3;
//	public static final int Pt_ARG_PG_SELECTION_MODE			= 64 * 1000 + 4;
	public static final int Pt_ARG_PG_CURRENT_INDEX				= 64 * 1000 + 5;
//	public static final int Pt_ARG_PG_OVERLAP_THRESHOLD			= 64 * 1000 + 6;
//	public static final int Pt_ARG_PG_DEFAULT_TAB_COLOR			= 64 * 1000 + 7;
	public static final int Pt_CB_PG_PANEL_SWITCHING			= 64 * 1000 + 10;
	public static final int Pt_PG_INVALID						= 65535;

	public static final int Pt_ARG_TITLE			= 10 * 1000 + 7;
	public static final int Pt_ARG_TITLE_FONT			= 10 * 1000 + 8;
	public static final int Pt_SHOW_TITLE			= 0x00000100;
	public static final int Pt_ETCH_TITLE_AREA		= 0x00000200;
	public static final int Pt_GRADIENT_TITLE_AREA		= 0x00000400;

	public static final int PF_STYLE_BOLD		= 0x1;
	public static final int PF_STYLE_ITALIC		= 0x2;

	public static final int PHFONT_DONT_SHOW_LEGACY		= 0x40;
			
//	public static final int Pt_ARG_CS_COLOR                                   = ( 150 * 1000 + 1 );
//	public static final int Pt_ARG_CS_COLOR_MODELS                                   = ( 150 * 1000 + 2 );
//	public static final int Pt_ARG_CS_PALETTE                                   = ( 150 * 1000 + 4 );
	
	public static final int Ph_WM_RENDER_COLLAPSE                                    = 0x00004000;

	public static final int Pt_ARG_LABEL_IMAGE                                     = ( 3 * 1000 + 1 );

	public static final int Pt_ARG_TOOLBAR_FLAGS                                     = ( 61 * 1000 + 0 );
	public static final int Pt_ARG_TOOLBAR_SPACING                                     = ( 61 * 1000 + 1 );
	public static final int Pt_TOOLBAR_DRAGGABLE                                     = 0x0001;
	public static final int Pt_TOOLBAR_ITEM_SEPARATORS                                     = 0x0020;
	public static final int Pt_TOOLBAR_END_SEPARATOR                                     = 0x0040;

	public static final int Pt_COLORSELECT_MODAL                                     = 0x4;
	public static final int Pt_COLORSELECT_ACCEPT                                     = 0x8000;
	
	public static final int Pt_PROCESS                                     = 0;
//	public static final int Pt_IGNORE                                      = 1;
	public static final int Pt_CONSUME                                     = 2;
	public static final int Pt_CB_FILTER                                          = ( 1 * 1000 + 26 );
	
	public static final int Pt_ALL_BUTTONS                                          = 0x00800000;
	public static final int Pt_MENUABLE                                          	= 0x08000000;

	public static final int Ph_CONSUMED                                          	= 0x0004;
	
	public static final int Pt_ARG_MODIFIER_KEYS                                    = ( 7 * 1000 + 4 );

	public static final byte [] Pg_PAT_HALF = {(byte)0xAA, (byte)0x55, (byte)0xAA, (byte)0x55, (byte)0xAA, (byte)0x55, (byte)0xAA, (byte)0x55};

	public static final int Pt_ARG_BEVEL_CONTRAST                                    = ( 2 * 1000 + 20 );

	public static final int Pt_NO_PARENT	                                    = 1;
	
	public static final int Pt_CB_TREE_STATE	                                     = ( 23 * 1000 + 21 );
	public static final int Pt_CB_TREE_SELECTION	                                     = ( 23 * 1000 + 22 );
	public static final int Pt_TREE_COLLAPSING  = 0;
	public static final int Pt_TREE_EXPANDING   = 1;
	public static final int  Pt_HOTKEYS_FIRST     =                                    0x00000080;
/*** END MANUALLY ADDED/FIXED ***/

//public static final int Aw_ARG_ONOFF_STATE                                    = ( 5 * 1000 + 1 );
//public static final int Aw_CB_ONOFF_NEW_VALUE                                 = ( 5 * 1000 + 0 );
//public static final int DEV_CTRL_DEVICE_LAYER                                 = 1;
//public static final int DEV_CTRL_INPUT                                        = 1;
//public static final int DEV_CTRL_LAYER_MASK                                   = 0xf0000000;
//public static final int DEV_CTRL_OUTPUT                                       = 2;
//public static final int DEV_CTRL_PROTOCOL_LAYER                               = 2;
//public static final int DEV_CTRL_SWITCH_MASK                                  = 0x0f000000;
//public static final int DEV_CTRL_TRANSLATE                                    = 4;
//public static final int DEV_CTRL_TYPE_MASK                                    = 0x000000ff;
//public static final int IsBorder                                              = 0x00000200;
//public static final int IsColorMode                                           = 0x00010000;
//public static final int IsColors                                              = 0x04000000;
//public static final int IsCopies                                              = 0x00008000;
//public static final int IsDither                                              = 0x00400000;
//public static final int IsDuplex                                              = 0x00200000;
//public static final int IsInkType                                             = 0x01000000;
//public static final int IsIntensity                                           = 0x00800000;
//public static final int IsMargins                                             = 0x00000100;
//public static final int IsOrientation                                         = 0x00020000;
//public static final int IsPageRange                                           = 0x10000000;
//public static final int IsPaperCollate                                        = 0x00100000;
//public static final int IsPaperSize                                           = 0x00000040;
//public static final int IsPaperSource                                         = 0x00040000;
//public static final int IsPaperType                                           = 0x00080000;
//public static final int IsPrinterDpi                                          = 0x00000010;
//public static final int IsScale                                               = 0x00004000;
//public static final int IsSrcColors                                           = 0x02000000;
//public static final int IsSrcDim                                              = 0x00000001;
//public static final int IsSrcDpi                                              = 0x00001000;
//public static final int IsSrcOff                                              = 0x00000004;
//public static final int KEY_CAP_VALID                                         = 0x00000080;
//public static final int KEY_DEAD                                              = 0x40000000;
//public static final int KEY_DEAD_FLAG                                         = 0x80;
//public static final int KEY_DOWN                                              = 0x00000001;
//public static final int KEY_MASK                                              = 0x03ff;
//public static final int KEY_NOSYM_FLAG                                        = 0x40;
//public static final int KEY_OEM_CAP                                           = 0x80000000;
//public static final int KEY_REPEAT                                            = 0x00000002;
//public static final int KEY_SCAN_VALID                                        = 0x00000020;
//public static final int KEY_SYM_VALID                                         = 0x00000040;
//public static final int KEYBOARD_CTRL_ATTR_MASK                               = 0x000f0000;
//public static final int KEYBOARD_CTRL_DELAY                                   = 0x00001000;
//public static final int KEYBOARD_CTRL_DISPLAY                                 = 0x00000400;
//public static final int KEYBOARD_CTRL_DISPLAY_OFF                             = 0x00020000;
//public static final int KEYBOARD_CTRL_DISPLAY_ON                              = 0x00010000;
//public static final int KEYBOARD_CTRL_FILENAME                                = 0x00002000;
//public static final int KEYBOARD_CTRL_LAYER                                   = 0x00040000;
//public static final int KEYBOARD_CTRL_LAYER_MASK                              = DEV_CTRL_LAYER_MASK;
//public static final int KEYBOARD_CTRL_OFF                                     = 0x00000200;
//public static final int KEYBOARD_CTRL_ON                                      = 0x00000100;
//public static final int KEYBOARD_CTRL_RATE                                    = 0x00000800;
//public static final int KEYBOARD_CTRL_SWITCH_MASK                             = DEV_CTRL_SWITCH_MASK;
//public static final int KEYBOARD_CTRL_TYPE_MASK                               = (DEV_CTRL_TYPE_MASK << 8);
//public static final int KEYCAP                                                = 0x0400;
//public static final int KEYCODE_PC_KEYS                                       = 0xF000;
//public static final int KEYCODE_CAPS_LOCK                                     = (KEYCODE_PC_KEYS + 0xe5);
//public static final int KEYCODE_DELETE                                        = (KEYCODE_PC_KEYS + 0xff);
//public static final int KEYCODE_DOWN                                          = (KEYCODE_PC_KEYS + 0x54);
//public static final int KEYCODE_END                                           = (KEYCODE_PC_KEYS + 0x57);
//public static final int KEYCODE_ESCAPE                                        = (KEYCODE_PC_KEYS + 0x1b);
//public static final int KEYCODE_F1                                            = (KEYCODE_PC_KEYS + 0xbe);
//public static final int KEYCODE_F10                                           = (KEYCODE_PC_KEYS + 0xc7);
//public static final int KEYCODE_F11                                           = (KEYCODE_PC_KEYS + 0xc8);
//public static final int KEYCODE_F12                                           = (KEYCODE_PC_KEYS + 0xc9);
//public static final int KEYCODE_F2                                            = (KEYCODE_PC_KEYS + 0xbf);
//public static final int KEYCODE_F3                                            = (KEYCODE_PC_KEYS + 0xc0);
//public static final int KEYCODE_F4                                            = (KEYCODE_PC_KEYS + 0xc1);
//public static final int KEYCODE_F5                                            = (KEYCODE_PC_KEYS + 0xc2);
//public static final int KEYCODE_F6                                            = (KEYCODE_PC_KEYS + 0xc3);
//public static final int KEYCODE_F7                                            = (KEYCODE_PC_KEYS + 0xc4);
//public static final int KEYCODE_F8                                            = (KEYCODE_PC_KEYS + 0xc5);
//public static final int KEYCODE_F9                                            = (KEYCODE_PC_KEYS + 0xc6);
//public static final int KEYCODE_HOME                                          = (KEYCODE_PC_KEYS + 0x50);
//public static final int KEYCODE_INSERT                                        = (KEYCODE_PC_KEYS + 0x63);
//public static final int KEYCODE_KP_DELETE                                     = (KEYCODE_PC_KEYS + 0xae);
//public static final int KEYCODE_KP_DIVIDE                                     = (KEYCODE_PC_KEYS + 0xaf);
//public static final int KEYCODE_KP_DOWN                                       = (KEYCODE_PC_KEYS + 0xb2);
//public static final int KEYCODE_KP_END                                        = (KEYCODE_PC_KEYS + 0xb1);
//public static final int KEYCODE_KP_ENTER                                      = (KEYCODE_PC_KEYS + 0x8d);
//public static final int KEYCODE_KP_FIVE                                       = (KEYCODE_PC_KEYS + 0xb5);
//public static final int KEYCODE_KP_HOME                                       = (KEYCODE_PC_KEYS + 0xb7);
//public static final int KEYCODE_KP_INSERT                                     = (KEYCODE_PC_KEYS + 0xb0);
//public static final int KEYCODE_KP_LEFT                                       = (KEYCODE_PC_KEYS + 0xb4);
//public static final int KEYCODE_KP_MINUS                                      = (KEYCODE_PC_KEYS + 0xad);
//public static final int KEYCODE_KP_MULTIPLY                                   = (KEYCODE_PC_KEYS + 0xaa);
//public static final int KEYCODE_KP_PG_DOWN                                    = (KEYCODE_PC_KEYS + 0xb3);
//public static final int KEYCODE_KP_PG_UP                                      = (KEYCODE_PC_KEYS + 0xb9);
//public static final int KEYCODE_KP_PLUS                                       = (KEYCODE_PC_KEYS + 0xab);
//public static final int KEYCODE_KP_RIGHT                                      = (KEYCODE_PC_KEYS + 0xb6);
//public static final int KEYCODE_KP_UP                                         = (KEYCODE_PC_KEYS + 0xb8);
//public static final int KEYCODE_LEFT                                          = (KEYCODE_PC_KEYS + 0x51);
//public static final int KEYCODE_LEFT_ALT                                      = (KEYCODE_PC_KEYS + 0xe9);
//public static final int KEYCODE_LEFT_CTRL                                     = (KEYCODE_PC_KEYS + 0xe3);
//public static final int KEYCODE_LEFT_HYPER                                    = (KEYCODE_PC_KEYS + 0xed);
//public static final int KEYCODE_LEFT_SHIFT                                    = (KEYCODE_PC_KEYS + 0xe1);
//public static final int KEYCODE_MENU                                          = (KEYCODE_PC_KEYS + 0x67);
//public static final int KEYCODE_NUM_LOCK                                      = (KEYCODE_PC_KEYS + 0x7f);
//public static final int KEYCODE_PAUSE                                         = (KEYCODE_PC_KEYS + 0x13);
//public static final int KEYCODE_PG_DOWN                                       = (KEYCODE_PC_KEYS + 0x56);
//public static final int KEYCODE_PG_UP                                         = (KEYCODE_PC_KEYS + 0x55);
//public static final int KEYCODE_PRINT                                         = (KEYCODE_PC_KEYS + 0x61);
//public static final int KEYCODE_RETURN                                        = (KEYCODE_PC_KEYS + 0x0d);
//public static final int KEYCODE_RIGHT                                         = (KEYCODE_PC_KEYS + 0x53);
//public static final int KEYCODE_RIGHT_ALT                                     = (KEYCODE_PC_KEYS + 0xea);
//public static final int KEYCODE_RIGHT_CTRL                                    = (KEYCODE_PC_KEYS + 0xe4);
//public static final int KEYCODE_RIGHT_HYPER                                   = (KEYCODE_PC_KEYS + 0xee);
//public static final int KEYCODE_RIGHT_SHIFT                                   = (KEYCODE_PC_KEYS + 0xe2);
//public static final int KEYCODE_SCROLL_LOCK                                   = (KEYCODE_PC_KEYS + 0x14);
//public static final int KEYCODE_SYSREQ                                        = (KEYCODE_PC_KEYS + 0x6a);
//public static final int KEYCODE_TAB                                           = (KEYCODE_PC_KEYS + 0x09);
//public static final int KEYCODE_UP                                            = (KEYCODE_PC_KEYS + 0x52);
//public static final int KEYCOMPOSE_CODE                                       = 0x0000;
//public static final int KEYCOMPOSE_LAST                                       = 0x8000;
//public static final int KEYCOMPOSE_SIZE                                       = 0x3fff;
//public static final int KEYCOMPOSE_TABLE                                      = 0x4000;
//public static final int KEYGRP_MAX                                            = 15;
//public static final int KEYIND_CAPS_LOCK                                      = 0x04;
//public static final int KEYIND_NUM_LOCK                                       = 0x02;
//public static final int KEYIND_SCROLL_LOCK                                    = 0x01;
//public static final int KEYINDICATOR_MAX                                      = 7;
//public static final int KEYMAP_COMPOSE                                        = 5;
//public static final int KEYMAP_EXTENDED_MAP                                   = 1;
//public static final int KEYMAP_GEOMETRY                                       = 7;
//public static final int KEYMAP_GROUPS                                         = 2;
//public static final int KEYMAP_INDICATORS                                     = 6;
//public static final int KEYMAP_KEYS                                           = 3;
//public static final int KEYMAP_MAGIC                                          = 0x2044424b;
//public static final int KEYMAP_MODIFIERS                                      = 4;
//public static final int KEYMAP_NAME                                           = 0;
//public static final int KEYMODBIT_ALT                                         = 2;
//public static final int KEYMODBIT_ALT_LOCK                                    = 10;
//public static final int KEYMODBIT_ALTGR                                       = 3;
//public static final int KEYMODBIT_ALTGR_LOCK                                  = 11;
//public static final int KEYMODBIT_CAPS_LOCK                                   = 16;
//public static final int KEYMODBIT_CTRL                                        = 1;
//public static final int KEYMODBIT_CTRL_LOCK                                   = 9;
//public static final int KEYMODBIT_MASK                                        = 0x3f;
//public static final int KEYMODBIT_MOD6                                        = 5;
//public static final int KEYMODBIT_MOD6_LOCK                                   = 13;
//public static final int KEYMODBIT_MOD7                                        = 6;
//public static final int KEYMODBIT_MOD7_LOCK                                   = 14;
//public static final int KEYMODBIT_MOD8                                        = 7;
//public static final int KEYMODBIT_MOD8_LOCK                                   = 15;
//public static final int KEYMODBIT_NUM_LOCK                                    = 17;
//public static final int KEYMODBIT_SCROLL_LOCK                                 = 18;
//public static final int KEYMODBIT_SHIFT                                       = 0;
//public static final int KEYMODBIT_SHIFT_LOCK                                  = 8;
//public static final int KEYMODBIT_SHL3                                        = 4;
//public static final int KEYMODBIT_SHL3_LOCK                                   = 12;
//public static final int KEYMOD                                                = 0x0800;
//public static final int KEYMOD_ALT                                            = (1 << KEYMODBIT_ALT);
//public static final int KEYMOD_ALT_LOCK                                       = (1 << KEYMODBIT_ALT_LOCK);
//public static final int KEYMOD_ALTGR                                          = (1 << KEYMODBIT_ALTGR);
//public static final int KEYMOD_ALTGR_LOCK                                     = (1 << KEYMODBIT_ALTGR_LOCK);
//public static final int KEYMOD_AND                                            = 0x80;
//public static final int KEYMOD_CAPS_LOCK                                      = (1 << KEYMODBIT_CAPS_LOCK);
//public static final int KEYMOD_CTRL                                           = (1 << KEYMODBIT_CTRL);
//public static final int KEYMOD_CTRL_LOCK                                      = (1 << KEYMODBIT_CTRL_LOCK);
//public static final int KEYMOD_DOWN                                           = 0x40;
//public static final int KEYMOD_MOD6                                           = (1 << KEYMODBIT_MOD6);
//public static final int KEYMOD_MOD6_LOCK                                      = (1 << KEYMODBIT_MOD6_LOCK);
//public static final int KEYMOD_MOD7                                           = (1 << KEYMODBIT_MOD7);
//public static final int KEYMOD_MOD7_LOCK                                      = (1 << KEYMODBIT_MOD7_LOCK);
//public static final int KEYMOD_MOD8                                           = (1 << KEYMODBIT_MOD8);
//public static final int KEYMOD_MOD8_LOCK                                      = (1 << KEYMODBIT_MOD8_LOCK);
//public static final int KEYMOD_NUM_LOCK                                       = (1 << KEYMODBIT_NUM_LOCK);
//public static final int KEYMOD_OR                                             = 0x00;
//public static final int KEYMOD_PRESS                                          = 0xc0;
//public static final int KEYMOD_RELEASE                                        = 0x80;
//public static final int KEYMOD_SCROLL_LOCK                                    = (1 << KEYMODBIT_SCROLL_LOCK);
//public static final int KEYMOD_SHIFT                                          = (1 << KEYMODBIT_SHIFT);
//public static final int KEYMOD_SHIFT_LOCK                                     = (1 << KEYMODBIT_SHIFT_LOCK);
//public static final int KEYMOD_SHL3                                           = (1 << KEYMODBIT_SHL3);
//public static final int KEYMOD_SHL3_LOCK                                      = (1 << KEYMODBIT_SHL3_LOCK);
//public static final int KEYMOD_UP                                             = 0x00;
//public static final int MAX_FONT_TAG                                          = 80;
//public static final int NAME_MAX                                              = 48;
//public static final int NUMERIC_BUF                                           = 40;
//public static final int PaperCollateAAABBBCCC                                 = 0x0002;
//public static final int PaperCollateABCABCABC                                 = 0x0001;
//public static final int PaperCollateDefault                                   = 0x0000;
//public static final int PaperSourceAuto                                       = 0x0001;
//public static final int PaperSourceDefault                                    = 0x0000;
//public static final int PaperSourceEnvelope                                   = 0x0005;
//public static final int PaperSourceLower                                      = 0x0003;
//public static final int PaperSourceManual                                     = 0x0004;
//public static final int PaperSourceManualEnv                                  = 0x0006;
//public static final int PaperSourceUpper                                      = 0x0002;
//public static final int PaperTypeDefault                                      = 0x0000;
//public static final int PaperTypeDraftQuality                                 = 0x0003;
//public static final int PaperTypeEnvelope                                     = 0x0005;
//public static final int PaperTypeHighQuality                                  = 0x0002;
//public static final int PaperTypeNormal                                       = 0x0001;
//public static final int PaperTypeTransparency                                 = 0x0004;
//public static final int PaperTypeTShirt                                       = 0x0006;
//public static final int PFR_STATS                                             = 0x02;
//public static final int Pg_DRAW_ARC                                           = 0x44;
//public static final int Pg_DRAW_BEVELBOX                                      = 0x45;
//public static final int Pg_DRAW_BEZIER                                        = 0x47;
//public static final int Pg_DRAW_BITBLIT                                       = 0x46;
//public static final int Pg_DRAW_BITBLT                                        = 0x46;
//public static final int Pg_DRAW_BITBLT_CHROMA                                 = 0x4A;
//public static final int Pg_DRAW_BITMAP                                        = 0x44;
//public static final int Pg_DRAW_ELLIPSE                                       = 0x43;
	public static final int Pg_DRAW_FILL                                          = 0x20;
	public static final int Pg_DRAW_STROKE                                        = 0x10;
//public static final int Pg_DRAW_FILL_STROKE                                   = (Pg_DRAW_FILL | Pg_DRAW_STROKE);
//public static final int Pg_DRAW_GETIMAGE                                      = 0x4F;
//public static final int Pg_DRAW_GRADIENT                                      = 0xD2;
//public static final int Pg_DRAW_GRID                                          = 0x47;
//public static final int Pg_DRAW_IMAGE                                         = 0x45;
//public static final int Pg_DRAW_LINE                                          = 0x42;
//public static final int Pg_DRAW_POINT                                         = 0x40;
//public static final int Pg_DRAW_POINT_ARRAY                                   = 0x41;
//public static final int Pg_DRAW_POLYGON                                       = 0x40;
//public static final int Pg_DRAW_RECT                                          = 0x41;
//public static final int Pg_DRAW_RRECT                                         = 0x42;
//public static final int Pg_DRAW_SPAN                                          = 0x46;
//public static final int Pg_DRAW_STROKE_FILL                                   = Pg_DRAW_FILL_STROKE;
//public static final int Pg_DRAW_TEXT                                          = 0x43;
//public static final int Pg_DRAW_TREND                                         = 0x48;
//public static final int Pg_DRAW_VECTOR                                        = 0x49;
	public static final int Pg_ARC                                                = (0x20 << 8);
//public static final int Pg_ARC_CHORD                                          = (0x00 << 8);
	public static final int Pg_ARC_PIE                                            = (0x10 << 8);
//public static final int Pg_ARC_FILL                                           = Pg_DRAW_FILL;
//public static final int Pg_ARC_FILL_CHORD                                     = Pg_DRAW_STROKE | Pg_ARC_CHORD;
//public static final int Pg_ARC_FILL_PIE                                       = Pg_DRAW_FILL | Pg_ARC_PIE;
//public static final int Pg_ARC_STROKE                                         = Pg_DRAW_STROKE;
//public static final int Pg_ARC_STROKE_ARC                                     = Pg_DRAW_STROKE | Pg_ARC;
//public static final int Pg_ARC_STROKE_CHORD                                   = Pg_DRAW_STROKE | Pg_ARC_CHORD;
//public static final int Pg_ARC_STROKE_PIE                                     = Pg_DRAW_STROKE | Pg_ARC_PIE;
	public static final int Pg_BACK_FILL                                          = (0x01 << 8);
//public static final int Pg_BEVEL_ADOWN                                        = 0xE000;
//public static final int Pg_BEVEL_ALEFT                                        = 0x2000;
//public static final int Pg_BEVEL_ARIGHT                                       = 0x6000;
//public static final int Pg_BEVEL_ARROW                                        = 0x2000;
//public static final int Pg_BEVEL_AUP                                          = 0xA000;
//public static final int Pg_BEVEL_CLIP                                         = 0x8000;
//public static final int Pg_BEVEL_JOIN                                         = 0x02;
//public static final int Pg_BEVEL_MAX                                          = 15;
//public static final int Pg_BEVEL_ROUND                                        = 0xC000;
//public static final int Pg_BEVEL_SET                                          = 0x1000;
//public static final int Pg_BEVEL_SQUARE                                       = 0x0000;
//public static final int Pg_BEVEL_TYPE_MASK                                    = 0xE000;
public static final int Pg_BITMAP_BACKFILL                                    = 0xFE;
public static final int Pg_BITMAP_TRANSPARENT                                 = 0xFF;
//public static final int Pg_BUTT_CAP                                           = 0x00;
//public static final int Pg_BUTT_JOIN                                          = 0x04;
//public static final int Pg_CAH_INLINE_OFF_SIZE                                = 0x00000040;
//public static final int Pg_CAH_RECORD_SIZE_MASK                               = 0x0000003F;
//public static final int Pg_CAH_RELAY_TAGGED                                   = 0x00002000;
//public static final int Pg_CAH_SHMEM_LIMIT                                    = 0x00000100;
//public static final int Pg_CAH_SHMEM_NAME                                     = 0x00000080;
//public static final int Pg_CAH_SHMEM_OFFSET                                   = 0x00000200;
//public static final int Pg_CAH_SRCE_OFFSET                                    = 0x00000800;
//public static final int Pg_CAH_SRCE_SIZE                                      = 0x00001000;
//public static final int Pg_CAH_SRCE_TAG                                       = 0x00000400;
//public static final int Pg_CENTER_BASED                                       = (0x00 << 8);
//public static final int Pg_CHROMA_DEST_KEY                                    = 0x00000001;
//public static final int Pg_CHROMA_DEST_MATCH                                  = 1;
//public static final int Pg_CHROMA_DRAW                                        = 0;
//public static final int Pg_CHROMA_NODRAW                                      = 2;
//public static final int Pg_CHROMA_NOT_DST_KEY                                 = 0x00000003;
//public static final int Pg_CHROMA_NOT_SRC_KEY                                 = 0x00000002;
//public static final int Pg_CHROMA_SRC_KEY                                     = 0x00000000;
//public static final int Pg_CHROMA_SRC_MATCH                                   = 0;
//public static final int Pg_CLIPTEST_CURSOR_HIDE                               = 0x0020;
	public static final int Pg_CLOSED                                             = (0x10 << 8);
//public static final int Pg_CMD_CAH_COUNT_1                                    = 0x00010000;
//public static final int Pg_CMD_CAH_COUNT_2                                    = 0x00020000;
//public static final int Pg_CMD_CAH_COUNT_3                                    = 0x00030000;
//public static final int Pg_CMD_CAH_COUNT_MASK                                 = 0x00030000;
//public static final int Pg_CMD_CAH_COUNT_UNIT                                 = 0x00010000;
//public static final int Pg_CMD_CMD_SIZE_MASK                                  = 0xFFFC0000;
	public static final int Pg_TRANSPARENT		                                  = 0xFFFFFFFF;
//public static final int Pg_INVERT_COLOR		                                  = 0xFFFFFFFE;
//public static final int Pg_CURSOR_SHOW                                        = 0x0080;
//public static final int Pg_DASH_INVERT                                        = 0x40;
//public static final int Pg_DASH_SLOPE_ADJ                                     = 0x80;
//public static final int Pg_DELETE_CURSOR                                      = 0x80;
//public static final int Pg_DLL_CMDS                                           = 0xD0;
//public static final int Pg_DO_EXTENT                                          = 0x0002;
//public static final int Pg_DOUBLE_UNDERLINE                                   = 0x10;
//public static final int Pg_DRAWMODE_AND                                       = 2;
//public static final int Pg_DRAWMODE_ANDINV                                    = 6;
//public static final int Pg_DRAWMODE_ANDREV                                    = 0xA;
//public static final int Pg_DRAWMODE_CLEAR                                     = 8;
//public static final int Pg_DRAWMODE_COPYINV                                   = 4;
//public static final int Pg_DRAWMODE_INVERT                                    = 0xD;
//public static final int Pg_DRAWMODE_NAND                                      = 0xF;
//public static final int Pg_DRAWMODE_NOP                                       = 9;
//public static final int Pg_DRAWMODE_NOR                                       = 0xE;
	public static final int Pg_DRAWMODE_OPAQUE                                    = 0;
//public static final int Pg_DRAWMODE_OR                                        = 3;
//public static final int Pg_DRAWMODE_ORINV                                     = 7;
//public static final int Pg_DRAWMODE_ORREV                                     = 0xB;
//public static final int Pg_DRAWMODE_SET                                       = 0xC;
//public static final int Pg_DRAWMODE_XNOR                                      = 5;
	public static final int Pg_DRAWMODE_XOR                                       = 1;
//public static final int Pg_ENABLE_CHROMA                                      = 0x00000004;
//public static final int Pg_END_OF_DRAW                                        = 0x00;
//public static final int Pg_ENDIAN_TEST                                        = 0xD5;
//public static final int Pg_EXPOSE_SOURCE                                      = (0x02 << 8);
	public static final int Pg_EXTENT_BASED                                       = (0x01 << 8);
//public static final int Pg_GHOST                                              = 0x01000000;
	public static final int Pg_IMAGE_PALETTE_BYTE                                 = 0x10;
//public static final int Pg_IMAGE_BYTE_PALETTE                                 = Pg_IMAGE_PALETTE_BYTE;
//public static final int Pg_IMAGE_CLASS_BLEND                                  = 0x08;
	public static final int Pg_IMAGE_CLASS_DIRECT                                 = 0x20;
//public static final int Pg_IMAGE_CLASS_GRADIENT                               = 0x18;
	public static final int Pg_IMAGE_CLASS_MASK                                   = 0x38;
	public static final int Pg_IMAGE_CLASS_PALETTE                                = 0x10;
//public static final int Pg_IMAGE_DBLEND_LONG                                  = 0x0B;
//public static final int Pg_IMAGE_DBLEND_SHORT                                 = 0x0A;
	public static final int Pg_IMAGE_DIRECT_444                                   = 0x24;
	public static final int Pg_IMAGE_DIRECT_555                                   = 0x23;
	public static final int Pg_IMAGE_DIRECT_565                                   = 0x22;
	public static final int Pg_IMAGE_DIRECT_888                                   = 0x21;
	public static final int Pg_IMAGE_DIRECT_8888                                  = 0x20;
//public static final int Pg_IMAGE_GBLEND_BYTE                                  = 0x08;
//public static final int Pg_IMAGE_GBLEND_NIBBLE                                = 0x09;
//public static final int Pg_IMAGE_GRADIENT_BYTE                                = 0x18;
//public static final int Pg_IMAGE_GRADIENT_NIBBLE                              = 0x19;
	public static final int Pg_IMAGE_PALETTE_NIBBLE                               = 0x11;
//public static final int Pg_IMAGE_NIBBLE_PALETTE                               = Pg_IMAGE_PALETTE_NIBBLE;
//public static final int Pg_ITEST_CURSOR_HIDE                                  = 0x0010;
//public static final int Pg_MITER_JOIN                                         = 0x00;
//public static final int Pg_MOVE_DISPLAY                                       = 0x4D;
//public static final int Pg_OVRFN_EQ                                           = 5;
//public static final int Pg_OVRFN_FALSE                                        = 0;
//public static final int Pg_OVRFN_GE                                           = 2;
//public static final int Pg_OVRFN_GT                                           = 7;
//public static final int Pg_OVRFN_LE                                           = 6;
//public static final int Pg_OVRFN_LT                                           = 3;
//public static final int Pg_OVRFN_NE                                           = 4;
//public static final int Pg_OVRFN_TRUE                                         = 1;
//public static final int Pg_PALSET_FORCE_EXPOSE                                = 0x80;
//public static final int Pg_PALSET_GLOBAL                                      = 0x03;
//public static final int Pg_PALSET_HARD                                        = 0x01;
//public static final int Pg_PALSET_HARDINACTIVE                                = 0x05;
//public static final int Pg_PALSET_HARDLOCKED                                  = 0x02;
	public static final int Pg_PALSET_SOFT                                        = 0x00;
//public static final int Pg_PALSET_TYPEMASK                                    = 0x0F;
//public static final int Pg_POINT_CAP                                          = 0x03;
//public static final int Pg_RELATIVE                                           = (0x01 << 8);
//public static final int Pg_REPBM_ALTERNATE                                    = (0x10 <<16);
//public static final int Pg_POLY_FILL                                          = Pg_DRAW_FILL;
//public static final int Pg_POLY_RELATIVE                                      = Pg_RELATIVE;
//public static final int Pg_POLY_STROKE                                        = Pg_DRAW_STROKE;
//public static final int Pg_POLY_STROKE_CLOSED                                 = Pg_DRAW_STROKE | Pg_CLOSED;
//public static final int Pg_PRINTER_CMD                                        = 0xF1;
//public static final int Pg_QROUND_JOIN                                        = 0x03;
//public static final int Pg_REL_POLY_FILL                                      = (Pg_POLY_FILL | Pg_POLY_RELATIVE);
//public static final int Pg_REL_POLY_STROKE                                    = (Pg_POLY_STROKE | Pg_POLY_RELATIVE);
//public static final int Pg_REL_POLY_STROKE_CLOSED                             = (Pg_POLY_STROKE_CLOSED | Pg_POLY_RELATIVE);
//public static final int Pg_ROUND_CAP                                          = 0x01;
//public static final int Pg_ROUND_JOIN                                         = 0x01;
//public static final int Pg_SET                                                = 1;
//public static final int Pg_SET_AUX_CLIP                                       = 0x07;
//public static final int Pg_SET_CURSOR_BITMAP                                  = 0x83;
//public static final int Pg_SET_CURSOR_CHAR                                    = 0x82;
//public static final int Pg_SET_CURSOR_POSITION                                = 0x81;
//public static final int Pg_SET_DEFAULT_STATE                                  = 0x01;
//public static final int Pg_SET_DRAG_CURSOR                                    = 0x84;
//public static final int Pg_SET_DRAW_MODE                                      = 0x02;
//public static final int Pg_SET_FILL_COLOR                                     = 0x20;
//public static final int Pg_SET_FILL_DITHER                                    = 0x22;
//public static final int Pg_SET_FILL_TRANSP                                    = 0x23;
//public static final int Pg_SET_FILL_XOR_COLOR                                 = 0x21;
//public static final int Pg_SET_PALETTE                                        = 0x08;
//public static final int Pg_SET_PLANE_MASK                                     = 0x03;
//public static final int Pg_SET_ROTATION                                       = 0x0B;
//public static final int Pg_SET_SCALE                                          = 0x0A;
//public static final int Pg_SET_STROKE_CAP                                     = 0x15;
//public static final int Pg_SET_STROKE_COLOR                                   = 0x10;
//public static final int Pg_SET_STROKE_DASH                                    = 0x17;
//public static final int Pg_SET_STROKE_DITHER                                  = 0x12;
//public static final int Pg_SET_STROKE_JOIN                                    = 0x16;
//public static final int Pg_SET_STROKE_TRANSP                                  = 0x13;
//public static final int Pg_SET_STROKE_WIDTH                                   = 0x14;
//public static final int Pg_SET_STROKE_XOR_COLOR                               = 0x11;
//public static final int Pg_SET_TEXT_COLOR                                     = 0x30;
//public static final int Pg_SET_TEXT_DITHER                                    = 0x32;
//public static final int Pg_SET_TEXT_FONT                                      = 0x34;
//public static final int Pg_SET_TEXT_TRANSP                                    = 0x33;
//public static final int Pg_SET_TEXT_UNDERLINE                                 = 0x35;
//public static final int Pg_SET_TEXT_XOR_COLOR                                 = 0x31;
//public static final int Pg_SET_TRANSLATION                                    = 0x09;
//public static final int Pg_SET_USER_CLIP                                      = 0x06;
//public static final int Pg_SETGAMMA_CBlack                                    = 0x0004;
//public static final int Pg_SETGAMMA_CFactor                                   = 0x0002;
//public static final int Pg_SETGAMMA_CWhite                                    = 0x0008;
//public static final int Pg_SETGAMMA_Factor                                    = 0x0001;
//public static final int Pg_SMART_BLIT                                         = (0x01 << 8);
//public static final int Pg_SQUARE_CAP                                         = 0x02;
//public static final int Pg_STRETCH_BLT                                        = 0x00000008;
//public static final int Pg_SWAP_DISPLAY                                       = 0xD4;
//public static final int Pg_SYNC                                               = 0xD3;
//public static final int Pg_TARGET_STREAM                                      = 0xD1;
//public static final int Pg_TEST_BITMAP                                        = 2;
//public static final int Pg_TEST_FILL                                          = (Pg_DRAW_FILL);
//public static final int Pg_TEST_FILL_STROKE                                   = (Pg_DRAW_FILL | Pg_DRAW_STROKE);
//public static final int Pg_TEST_STROKE                                        = (Pg_DRAW_STROKE);
//public static final int Pg_TEST_TEXT                                          = 1;
//public static final int Pg_TEXT_AREA                                          = (0x08 << 8);
//public static final int Pg_TEXT_BOTTOM                                        = (0x80 << 8);
	public static final int Pg_TEXT_LEFT                                          = (0x10 << 8);
//public static final int Pg_TEXT_RIGHT                                         = (0x20 << 8);
	public static final int Pg_TEXT_TOP                                           = (0x40 << 8);
//public static final int Pg_TEXT_CENTER                                        = ( Pg_TEXT_LEFT | Pg_TEXT_RIGHT );
//public static final int Pg_TEXT_MIDDLE                                        = ( Pg_TEXT_TOP | Pg_TEXT_BOTTOM );
//public static final int Pg_TEXT_SIZE_HINT                                     = (0x02 << 8);
	public static final int Pg_TEXT_UTF2CHAR                                      = (0x04 << 8);
	public static final int Pg_TEXT_WIDECHAR                                      = (Pg_TEXT_UTF2CHAR);
//public static final int Pg_TREND_HORIZ                                        = 0x00;
//public static final int Pg_TREND_VERT                                         = 0x01;
//public static final int Pg_UNSET                                              = 0;
//public static final int Pg_WAIT_VSYNC                                         = 0x00000010;
//public static final int Pg_XADDR_INLINE                                       = 1;
//public static final int Pg_XADDR_SHMEM                                        = 0;
//public static final int Pgrs_RelBehind                                        = 0x0002;
//public static final int Pgrs_RelInFront                                       = 0x0001;
//public static final int Pgrs_RelParent                                        = 0x0000;
//public static final int PgrsI_CreatedShmem                                    = 0x0001;
//public static final int Pgv_C_ByteFlag                                        = 0x00000800;
//public static final int Pgv_C_ByteIndex                                       = 0x00000600;
//public static final int Pgv_C_Direct                                          = 0x00000400;
//public static final int Pgv_C_DStrokePen                                      = 0x00000200;
//public static final int Pgv_C_MASK                                            = 0x00000E00;
//public static final int Pgv_C_StrokePen                                       = 0x00000000;
//public static final int Pgv_O_FixedLine                                       = 0x00000000;
//public static final int Pgv_O_MASK                                            = 0x03000000;
//public static final int Pgv_O_Variable                                        = 0x01000000;
//public static final int Pgv_OP_Glyph                                          = 0x80;
//public static final int Pgv_OP_Line                                           = 0x01;
//public static final int Pgv_OP_NOP                                            = 0x00;
//public static final int Pgv_OP_Point                                          = 0x02;
//public static final int Pgv_P_Color                                           = 0x00200000;
//public static final int Pgv_P_MASK                                            = 0x00F00000;
//public static final int Pgv_P_Simple                                          = 0x00100000;
//public static final int Pgv_T_MASK                                            = 0x00003000;
//public static final int Pgv_T_PostTrans                                       = 0x00002000;
//public static final int Pgv_T_PreTrans                                        = 0x00001000;
//public static final int Pgv_T_ZTrans                                          = 0x00004000;
//public static final int Pgv_X_Char                                            = 0x00000002;
//public static final int Pgv_X_LFixed                                          = 0x00000004;
//public static final int Pgv_X_MASK                                            = 0x00000007;
//public static final int Pgv_X_Short                                           = 0x00000003;
//public static final int Pgv_X_UseDelta                                        = 0x00000001;
//public static final int Pgv_Y_Char                                            = (Pgv_X_Char << 3);
//public static final int Pgv_Y_LFixed                                          = (Pgv_X_LFixed << 3);
//public static final int Pgv_Y_MASK                                            = (Pgv_X_MASK << 3);
//public static final int Pgv_Y_Short                                           = (Pgv_X_Short << 3);
//public static final int Pgv_Y_UseDelta                                        = (Pgv_X_UseDelta << 3);
//public static final int Pgv_Z_Char                                            = (Pgv_X_Char << 6);
//public static final int Pgv_Z_LFixed                                          = (Pgv_X_LFixed << 6);
//public static final int Pgv_Z_MASK                                            = (Pgv_X_MASK << 6);
//public static final int Pgv_Z_Short                                           = (Pgv_X_Short << 6);
//public static final int Pgv_Z_UseDelta                                        = (Pgv_X_UseDelta << 6);
//public static final int Ph_ACTIVATE_DC                                        = 0;
//public static final int Ph_AUDIO_REGION                                       = 0x00000100;
//public static final int Ph_AUXPTR_REGION                                      = 0x00000080;
//public static final int Ph_BACK_EVENT                                         = 0x0002;
//public static final int Ph_BAUD_CONSOLE                                       = 100000000;
//public static final int Ph_BAUD_NETWORK                                       = 10000000;
//public static final int Ph_BAUD_SLOW                                          = 100000;
//public static final int Ph_BLIT_REGION                                        = 0x00008000;
//public static final int Ph_BLOCK_OVERFLOW                                     = 0x00000001;
	public static final int Ph_BUTTON_ADJUST                                      = 0x0002;
	public static final int Ph_BUTTON_MENU                                        = 0x0001;
	public static final int Ph_BUTTON_SELECT                                      = 0x0004;
//	public static final int Ph_BUTTON_1                                           = Ph_BUTTON_MENU;
//	public static final int Ph_BUTTON_2                                           = Ph_BUTTON_ADJUST;
//	public static final int Ph_BUTTON_3                                           = Ph_BUTTON_SELECT;
//public static final int Ph_CAPTURE_EXPOSE                                     = 4;
//public static final int Ph_CLIPBOARD_MAX_TYPES                                = 5;
//public static final int Ph_COMPOUND_REPLY                                     = 0x00000020;
//public static final int Ph_CURSOR_BACK                                        = 2;
//public static final int Ph_CURSOR_BIG_POINTER                                 = 0xE902;
	public static final int Ph_CURSOR_BITMAP                                      = 0xFB;
	public static final int Ph_CURSOR_CLOCK                                       = 0xE908;
	public static final int Ph_CURSOR_CROSSHAIR                                   = 0xE906;
	public static final int Ph_CURSOR_DEFAULT_COLOR                               = 0xFFFFE0;
	public static final int Ph_CURSOR_DONT                                        = 0xE90A;
//public static final int Ph_CURSOR_DRAG_BACKDIAG                               = 0xE914;
	public static final int Ph_CURSOR_DRAG_BL                                     = 0xE916;
	public static final int Ph_CURSOR_DRAG_BOTTOM                                 = 0xE910;
	public static final int Ph_CURSOR_DRAG_BR                                     = 0xE914;
//public static final int Ph_CURSOR_DRAG_FOREDIAG                               = 0xE916;
	public static final int Ph_CURSOR_DRAG_HORIZONTAL                             = 0xE912;
	public static final int Ph_CURSOR_DRAG_LEFT                                   = 0xE912;
	public static final int Ph_CURSOR_DRAG_RIGHT                                  = 0xE912;
	public static final int Ph_CURSOR_DRAG_TL                                     = 0xE914;
	public static final int Ph_CURSOR_DRAG_TOP                                    = 0xE910;
	public static final int Ph_CURSOR_DRAG_TR                                     = 0xE916;
	public static final int Ph_CURSOR_DRAG_VERTICAL                               = 0xE910;
	public static final int Ph_CURSOR_FINGER                                      = 0xE90C;
//public static final int Ph_CURSOR_FRONT                                       = 1;
	public static final int Ph_CURSOR_INHERIT                                     = 0x00;
	public static final int Ph_CURSOR_INSERT                                      = 0xE90E;
//public static final int Ph_CURSOR_LONG_WAIT                                   = 0xE91A;
//public static final int Ph_CURSOR_MANUAL_CONTROL                              = 0xFF;
	public static final int Ph_CURSOR_MOVE                                        = 0xE904;
	public static final int Ph_CURSOR_NO_INHERIT                                  = 0x01;
//public static final int Ph_CURSOR_NOINPUT                                     = 0xE90A;
//public static final int Ph_CURSOR_NONE                                        = 0xFD;
//public static final int Ph_CURSOR_PASTE                                       = 0xE91E;
	public static final int Ph_CURSOR_POINT_WAIT                                  = 0xE918;
	public static final int Ph_CURSOR_POINTER                                     = 0xE900;
	public static final int Ph_CURSOR_QUESTION_POINT                              = 0xE91C;
//public static final int Ph_CURSOR_SET                                         = 0x01000000;
//public static final int Ph_CURSOR_WAIT                                        = 0xE908;
//public static final int Ph_DEACTIVATE_DC                                      = 1;
//public static final int Ph_DESTROYING_DC                                      = 2;
	public static final int Ph_DEV_RID                                            = 1;
//public static final int Ph_DIRECTED_FOCUS                                     = 0x0004;
//public static final int Ph_DONE_DRAW                                          = 0x8000;
//public static final int Ph_DRAG_ABSOLUTE                                      = 0x0080;
//public static final int Ph_DRAG_CURSOR_EXACT                                  = 0x0400;
//public static final int Ph_DRAG_DRAW_RECT                                     = 0x0100;
//public static final int Ph_DRAG_DRAW_RECT_INITIAL                             = 0x0200;
	public static final int Ph_DRAG_KEY_MOTION                                    = 0x0020;
	public static final int Ph_DRAG_NOBUTTON                                      = 0x0040;
	public static final int Ph_DRAG_TRACK                                         = 0x0010;
//public static final int Ph_DRAW_TO_MEMORY_CONTEXT                             = 2;
//public static final int Ph_DRAW_TO_PHOTON                                     = 0;
//public static final int Ph_DRAW_TO_PRINT_CONTEXT                              = 1;
//public static final int Ph_DRAW_TO_SERVICE                                    = 3;
//public static final int Ph_DYNAMIC_BUFFER                                     = 0x00000010;
//public static final int Ph_EMIT_TOWARD                                        = 0x0001;
//public static final int Ph_ESCAPE_COUNT_MASK                                  = 0x000F;
//public static final int Ph_EV_ADMIN_FILE_SENT                                 = 1;
//public static final int Ph_EV_ADMIN_SEND_FILE                                 = 0;
//public static final int Ph_EV_AMIN                                            = 0x00000100;
//public static final int Ph_EV_AUDIO                                           = 0x00100000;
//public static final int Ph_EV_BLIT                                            = 0x00000800;
	public static final int Ph_EV_BOUNDARY                                        = 0x00000020;
	public static final int Ph_EV_BUT_PRESS                                       = 0x00000002;
	public static final int Ph_EV_BUT_RELEASE                                     = 0x00000004;
//public static final int Ph_EV_BUT_REPEAT                                      = 0x00004000;
//public static final int Ph_EV_CONFIG                                          = 3;
//public static final int Ph_EV_COVERED                                         = 0x00000400;
//public static final int Ph_EV_DND_ACK                                         = 4;
//public static final int Ph_EV_DND_CANCEL                                      = 1;
//public static final int Ph_EV_DND_COMPLETE                                    = 7;
//public static final int Ph_EV_DND_DELIVERED                                   = 8;
//public static final int Ph_EV_DND_DROP                                        = 6;
//public static final int Ph_EV_DND_ENTER                                       = 2;
//public static final int Ph_EV_DND_INIT                                        = 0;
//public static final int Ph_EV_DND_LEAVE                                       = 3;
//public static final int Ph_EV_DND_MOTION                                      = 5;
//public static final int Ph_EV_DNDROP                                          = 0x00200000;
	public static final int Ph_EV_DRAG                                            = 0x00000200;
//public static final int Ph_EV_DRAG_BOUNDARY                                   = 5;
	public static final int Ph_EV_DRAG_COMPLETE                                   = 2;
//public static final int Ph_EV_DRAG_INIT                                       = 0;
	public static final int Ph_EV_DRAG_KEY_EVENT                                  = 3;
	public static final int Ph_EV_DRAG_MOTION_EVENT                               = 4;
//public static final int Ph_EV_DRAG_MOVE                                       = 1;
//public static final int Ph_EV_DRAG_START                                      = 6;
//public static final int Ph_EV_DRAW                                            = 0x00000080;
//public static final int Ph_EV_EXPOSE                                          = 0x00000040;
//public static final int Ph_EV_FEP                                             = 4;
//public static final int Ph_EV_INFO                                            = 0x00080000;
//public static final int Ph_EV_INVALIDATE_FONTINFO                             = 1;
//public static final int Ph_EV_INVALIDATE_SYSINFO                              = 0;
	public static final int Ph_EV_KEY                                             = 0x00000001;
//public static final int Ph_EV_KEY_NORMAL                                      = 0;
//public static final int Ph_EV_KEYBOARD_CTRL                                   = 3;
//public static final int Ph_EV_LB_SYSTEM                                       = 0x00020000;
//public static final int Ph_EV_MOTION_NORMAL                                   = 0;
//public static final int Ph_EV_MOTION_STEADY                                   = 1;
//public static final int Ph_EV_NEW_TIMEZONE                                    = 2;
//public static final int Ph_EV_POINTER_CTRL                                    = 2;
//public static final int Ph_EV_PRINTER                                         = 5;
	public static final int Ph_EV_PTR_ENTER                                       = 0;
	public static final int Ph_EV_PTR_ENTER_FROM_CHILD                            = 4;
//public static final int Ph_EV_PTR_ENTER_FROM_PARENT                           = 0;
	public static final int Ph_EV_PTR_LEAVE                                       = 1;
	public static final int Ph_EV_PTR_LEAVE_TO_CHILD                              = 5;
//public static final int Ph_EV_PTR_LEAVE_TO_PARENT                             = 1;
	public static final int Ph_EV_PTR_MOTION_BUTTON                               = 0x00000010;
	public static final int Ph_EV_PTR_MOTION_NOBUTTON                             = 0x00000008;
//public static final int Ph_EV_PTR_RECT_ENTER                                  = 0x10;
//public static final int Ph_EV_PTR_RECT_LEAVE                                  = 0x11;
	public static final int Ph_EV_PTR_STEADY                                      = 2;
//public static final int Ph_EV_PTR_TRANSIENT_ENTER                             = 8;
//public static final int Ph_EV_PTR_TRANSIENT_LEAVE                             = 9;
	public static final int Ph_EV_PTR_UNSTEADY                                    = 3;
	public static final int Ph_EV_PTR_MOTION                                      = ( Ph_EV_PTR_MOTION_NOBUTTON | Ph_EV_PTR_MOTION_BUTTON );
//public static final int Ph_EV_PTR_ALL                                         = ( Ph_EV_BUT_PRESS | Ph_EV_BUT_RELEASE | Ph_EV_PTR_MOTION | Ph_EV_BUT_REPEAT  );
//public static final int Ph_EV_RAW                                             = 0x00008000;
//public static final int Ph_EV_RAW_AUXPTR                                      = 2;
//public static final int Ph_EV_RAW_KEY                                         = 0;
//public static final int Ph_EV_RAW_PTR                                         = 1;
//public static final int Ph_EV_RELEASE_ENDCLICK                                = 2;
//public static final int Ph_EV_RELEASE_OUTBOUND                                = 3;
	public static final int Ph_EV_RELEASE_PHANTOM                                 = 1;
	public static final int Ph_EV_RELEASE_REAL                                    = 0;
//public static final int Ph_EV_REMOTE_WM                                       = 1;
//public static final int Ph_EV_SERVICE                                         = 0x00040000;
//public static final int Ph_EV_SYSTEM                                          = 0x00001000;
	public static final int Ph_EV_TIMER                                           = 0x00010000;
//public static final int Ph_EV_WIDGET_SENSE                                    = ( Ph_EV_KEY | Ph_EV_BUT_PRESS | Ph_EV_BUT_RELEASE | Ph_EV_DRAG | Ph_EV_BOUNDARY );
//public static final int Ph_EV_WIDGET_OPAQUE                                   = ( Ph_EV_WIDGET_SENSE | Ph_EV_PTR_ALL | Ph_EV_KEY );
//public static final int Ph_EV_WIN_SENSE                                       = ( Ph_EV_KEY | Ph_EV_BUT_PRESS | Ph_EV_BUT_RELEASE | Ph_EV_EXPOSE | Ph_EV_DRAG | Ph_EV_TIMER );
//public static final int Ph_EV_WIN_OPAQUE                                      = ( Ph_EV_WIN_SENSE | Ph_EV_PTR_ALL | Ph_EV_BOUNDARY | Ph_EV_DRAW | Ph_EV_COVERED | Ph_EV_KEY | Ph_EV_BUT_REPEAT );
//public static final int Ph_EV_WM                                              = 0x00002000;
//public static final int _Ph_REGION_OPEN	                                      = 0;
//public static final int _Ph_REGION_SET 	                                      = 1;
//public static final int _Ph_REGION_CLOSE 	                                  = 2;
//public static final int _Ph_REGION_WM_BASE 	                                  = 8;
//public static final int Ph_EV_WM_CLOSE                                        = _Ph_REGION_CLOSE;
//public static final int Ph_EV_WM_CONFIG                                       = (_Ph_REGION_WM_BASE+3);
//public static final int Ph_EV_WM_CONSWITCH                                    = (_Ph_REGION_WM_BASE+5);
//public static final int Ph_EV_WM_EVENT                                        = (_Ph_REGION_WM_BASE+0);
//public static final int Ph_EV_WM_MENUREAD                                     = (_Ph_REGION_WM_BASE+6);
//public static final int Ph_EV_WM_OPEN                                         = _Ph_REGION_OPEN;
//public static final int Ph_EV_WM_SET                                          = _Ph_REGION_SET;
//public static final int Ph_EV_WM_TASKEVENT                                    = (_Ph_REGION_WM_BASE+4);
//public static final int Ph_EV_WM_TRANSPORT                                    = (_Ph_REGION_WM_BASE+2);
//public static final int Ph_EV_WM_VISIBLE                                      = (_Ph_REGION_WM_BASE+1);
//public static final int Ph_EV_ICON_OPAQUE                                     = ( Ph_EV_WM | Ph_EV_EXPOSE | Ph_EV_DRAW );
//public static final int Ph_EV_ICON_SENSE                                      = ( Ph_EV_WM | Ph_EV_EXPOSE );
//public static final int Ph_EVENT_ABSOLUTE                                     = 0x0004;
	public static final int Ph_EVENT_DIRECT                                       = 0x0010;
//public static final int Ph_EVENT_INCLUSIVE                                    = 0x0008;
	public static final int Ph_EVENT_MSG                                          = 1;
//public static final int Ph_EVENT_NO_RECT                                      = 0x0002;
//public static final int Ph_EVENT_REDIRECTED                                   = 0x0020;
//public static final int Ph_EVENT_RSRV1                                        = 0x8000;
//public static final int Ph_EXPOSE_FAMILY                                      = 0x00002000;
//public static final int Ph_EXPOSE_REGION                                      = 0x00004000;
	public static final int Ph_FAKE_EVENT                                         = 0x0001;
//public static final int Ph_FEP_ACTIVATE                                       = 0x00000003;
//public static final int Ph_FEP_BROADCAST                                      = 0x00000000;
//public static final int Ph_FEP_CHINESE                                        = 0x00000002;
//public static final int Ph_FEP_DEACTIVATE                                     = 0x00000004;
//public static final int Ph_FEP_DEREGISTER                                     = 1;
//public static final int Ph_FEP_JAPANESE                                       = 0x00000001;
//public static final int Ph_FEP_KOREAN                                         = 0x00000003;
//public static final int Ph_FEP_NORECT                                         = 0x00000002;
//public static final int Ph_FEP_RECT                                           = 0x00000001;
//public static final int Ph_FEP_REGISTER                                       = 0;
//public static final int Ph_FOCUS_BRANCH                                       = 0x0008;
//public static final int Ph_FOLLOW_IG_SIZE                                     = 0x00200000;
	public static final int Ph_FORCE_BOUNDARY                                     = 0x00400000;
//public static final int Ph_FORCE_FRONT                                        = 0x00100000;
//public static final int Ph_GCAP_BLIT                                          = 0x00000001;
//public static final int Ph_GCAP_DIRECTCOLOR                                   = 0x00000100;
//public static final int Ph_GCAP_DRAW_OFFSCREEN                                = 0x00004000;
//public static final int Ph_GCAP_FRAME_READ                                    = 0x00001000;
//public static final int Ph_GCAP_FutureSupported                               = 0xFF000000;
//public static final int Ph_GCAP_LOCALHW                                       = 0x00000040;
//public static final int Ph_GCAP_MASKED_BLIT                                   = 0x00000002;
//public static final int Ph_GCAP_NONINTERLACED                                 = 0x00000400;
//public static final int Ph_GCAP_PALETTE                                       = 0x00000008;
//public static final int Ph_GCAP_PHINDOWS                                      = 0x00000020;
//public static final int Ph_GCAP_RELAY                                         = 0x00000010;
//public static final int Ph_GCAP_SHMEM                                         = 0x00000004;
//public static final int Ph_GCAP_SHMEM_FLUSH                                   = 0x00002000;
//public static final int Ph_GCAP_TEXT_AREA                                     = 0x00000800;
//public static final int Ph_GCAP_VIDEO_READABLE                                = 0x00000200;
//public static final int Ph_GEN_INFO_BANDWIDTH                                 = 0x000000001;
//public static final int Ph_GEN_INFO_CAPABILITIES                              = 0x000000002;
//public static final int Ph_GEN_INFO_NUM_GFX                                   = 0x000000004;
//public static final int Ph_GEN_INFO_NUM_IG                                    = 0x000000020;
//public static final int Ph_GEN_INFO_NUM_KBD                                   = 0x000000008;
//public static final int Ph_GEN_INFO_NUM_PTR                                   = 0x000000010;
//public static final int Ph_GFX_BANDWIDTH                                      = 0x00000001;
//public static final int Ph_GFX_CAPABILITIES                                   = 0x00000002;
//public static final int Ph_GFX_COLOR_BITS                                     = 0x00000004;
//public static final int Ph_GFX_POSSIBILITIES                                  = 0x00000008;
//public static final int Ph_GFXD_DITHERSTROKE                                  = 0x00000008;
//public static final int Ph_GFXD_HARDROT                                       = 0x00000002;
//public static final int Ph_GFXD_SCALEING                                      = 0x00000004;
//public static final int Ph_GFXD_VPANNING                                      = 0x00000001;
//public static final int Ph_GFXG_DMANDOR                                       = 0x00000020;
//public static final int Ph_GFXG_DMEXTENDED                                    = 0x00000040;
//public static final int Ph_GFXG_DMXOR                                         = 0x00000010;
//public static final int Ph_GFXG_HWBITBLT                                      = 0x00000002;
//public static final int Ph_GFXG_HWBITBLT_CHROMA                               = 0x00000080;
//public static final int Ph_GFXG_HWBITBLT_STRETCH                              = 0x00000100;
//public static final int Ph_GFXG_HWCURSOR                                      = 0x00000001;
//public static final int Ph_GFXG_MASKBLIT                                      = 0x00000004;
//public static final int Ph_GFXG_OFFSCREENMEM                                  = 0x00000008;
//public static final int Ph_GFXV_DIRECT                                        = 0x00000010;
//public static final int Ph_GFXV_MONOCHROME                                    = 0x00000001;
//public static final int Ph_GFXV_NONINTERLACED                                 = 0x00002000;
//public static final int Ph_GFXV_OVERLAY                                       = 0x00000020;
//public static final int Ph_GFXV_PALETTE16                                     = 0x00000002;
//public static final int Ph_GFXV_PALETTE256                                    = 0x00000004;
//public static final int Ph_GFXV_VIDEO_READABLE                                = 0x00001000;
//public static final int Ph_GFXVAL_BITPOS                                      = 0x00400000;
//public static final int Ph_GFXVAL_BPL                                         = 0x00100000;
//public static final int Ph_GFXVAL_BPP                                         = 0x00200000;
//public static final int Ph_GFXVAL_CARDSUBTYPE                                 = 0x00000020;
//public static final int Ph_GFXVAL_CARDTYPE                                    = 0x00000010;
//public static final int Ph_GFXVAL_COPT                                        = 0x00000008;
//public static final int Ph_GFXVAL_DACSIZE                                     = 0x00800000;
//public static final int Ph_GFXVAL_DOPT                                        = 0x00000002;
//public static final int Ph_GFXVAL_GOPT                                        = 0x00000004;
//public static final int Ph_GFXVAL_NCURSOR                                     = 0x00001000;
//public static final int Ph_GFXVAL_NPALETTE                                    = 0x00002000;
//public static final int Ph_GFXVAL_POINTBS                                     = 0x00004000;
//public static final int Ph_GFXVAL_PRES                                        = 0x00000100;
//public static final int Ph_GFXVAL_VOPT                                        = 0x00000001;
//public static final int Ph_GFXVAL_VRAMSIZE                                    = 0x00000800;
//public static final int Ph_GFXVAL_VRES                                        = 0x00000200;
//public static final int Ph_GFXVAL_WORKSPACES                                  = 0x00008000;
//public static final int Ph_GRAFX_REGION                                       = 0x00000004;
//public static final int Ph_GRAPHIC_EXPOSE                                     = 2;
//public static final int Ph_INFO_CTRL_BUF_GC                                   = 6;
//public static final int Ph_INFO_CTRL_DFLT_GC                                  = 5;
//public static final int Ph_INFO_CTRL_FD                                       = 0;
//public static final int Ph_INFO_CTRL_GC                                       = 4;
//public static final int Ph_INFO_CTRL_GIN                                      = 3;
//public static final int Ph_INFO_CTRL_PROXY                                    = 1;
//public static final int Ph_INFO_CTRL_REM_PROXY                                = 2;
//public static final int Ph_INLINE_SHMEM_OBJECTS                               = 0x00000001;
//public static final int Ph_INPUTGROUP_REGION                                  = 0x00000040;
//public static final int Ph_KBD_CAPABILITIES                                   = 0x00000001;
//public static final int Ph_KBD_REGION                                         = 0x00000010;
//public static final int Ph_LIB_VERSION                                        = 114;
//public static final int Ph_MAX_FONT_LEN                                       = 16;
//public static final int Ph_NO_COMPRESSION                                     = 0x00800000;
//public static final int Ph_NO_HOLD                                            = 0x00000008;
//public static final int Ph_NO_PROXY                                           = 0x00000004;
//public static final int Ph_NORMAL_DRAW                                        = 0x0000;
//public static final int Ph_NORMAL_EXPOSE                                      = 0;
	public static final int Ph_NOT_CUAKEY                                         = 0x10;
//public static final int Ph_NOT_HOTKEY                                         = 0x20;
//public static final int Ph_PRINT_REGION                                       = 0x00000020;
//public static final int Ph_PRINTER_EXPOSE                                     = 1;
//public static final int Ph_PROC_ARMED                                         = 0x0002;
//public static final int Ph_PROC_BLOCKED                                       = 0x0004;
//public static final int Ph_PROC_CATCH_UP                                      = 0x0010;
//public static final int Ph_PROC_DYNAMIC_BUF                                   = 0x0020;
//public static final int Ph_PROC_HELD                                          = 0x0008;
//public static final int Ph_PROC_VIRTUAL                                       = 0x0001;
//public static final int Ph_PTR_CAPABILITIES                                   = 0x00000001;
//public static final int Ph_PTR_FLAG_PROG                                      = 0x04;
//public static final int Ph_PTR_FLAG_Z_ABS                                     = 0x02;
//public static final int Ph_PTR_FLAG_Z_MASK                                    = 0x03;
//public static final int Ph_PTR_FLAG_Z_NONE                                    = 0x00;
//public static final int Ph_PTR_FLAG_Z_PRESSURE                                = 0x03;
//public static final int Ph_PTR_FLAG_Z_REL                                     = 0x01;
//public static final int Ph_PTR_RAW_FLAG_NO_BUTTONS                            = 0x01;
//public static final int Ph_PTR_RAW_FLAG_XY_REL                                = 0x02;
//public static final int Ph_PTR_REGION                                         = 0x00000008;
	public static final int Ph_QUERY_CONSOLE                                     = 0x0000;
//public static final int Ph_QUERY_DC_GRAFX_INFO                                = 0x80000000;
//public static final int Ph_QUERY_EXACT                                        = 0x0100;
	public static final int Ph_QUERY_GRAPHICS                                     = 0x0004;
//public static final int Ph_QUERY_IG_POINTER                                   = 0x1000;
//public static final int Ph_QUERY_IG_REGION                                    = 0x2000;
//public static final int Ph_QUERY_INPUT_GROUP                                  = 0x0040;
//public static final int Ph_QUERY_MEMORY_GRAFX_INFO                            = 0x80000000;
	public static final int Ph_QUERY_WORKSPACE                                  = 0x0002;
//public static final int Ph_RDATA_CLIPBOARD                                    = 0x000A;
//public static final int Ph_RDATA_CURSOR                                       = 0x0002;
//public static final int Ph_RDATA_GFXDETAIL                                    = 0x0008;
//public static final int Ph_RDATA_GFXINFO                                      = 0x0004;
//public static final int Ph_RDATA_IG                                           = 0x0003;
//public static final int Ph_RDATA_INPMGRINFO                                   = 0x0009;
//public static final int Ph_RDATA_KBDINFO                                      = 0x0005;
//public static final int Ph_RDATA_PTRINFO                                      = 0x0006;
//public static final int Ph_RDATA_USER                                         = 0xFFFF;
//public static final int Ph_RDATA_WINDOW                                       = 0x0001;
//public static final int Ph_RDATA_WMCONFIG                                     = 0x0007;
//public static final int Ph_RECT_BOUNDARY                                      = 0x02000000;
//public static final int Ph_REGION_BEHIND                                      = 0x00000200;
//public static final int Ph_REGION_CURSOR                                      = 0x00001000;
//public static final int Ph_REGION_DATA                                        = 0x00000800;
//public static final int Ph_REGION_EV_OPAQUE                                   = 0x00000008;
//public static final int Ph_REGION_EV_OPAQUE_AND                               = 0x00010000;
//public static final int Ph_REGION_EV_OPAQUE_OR                                = 0x00040000;
//public static final int Ph_REGION_EV_OPAQUE_SET                               = 0x00000008;
//public static final int Ph_REGION_EV_SENSE                                    = 0x00000010;
//public static final int Ph_REGION_EV_SENSE_AND                                = 0x00020000;
//public static final int Ph_REGION_EV_SENSE_OR                                 = 0x00080000;
//public static final int Ph_REGION_EV_SENSE_SET                                = 0x00000010;
//public static final int Ph_REGION_FLAGS                                       = 0x00000004;
//public static final int Ph_REGION_HANDLE                                      = 0x00000002;
//public static final int Ph_REGION_IN_FRONT                                    = 0x00000100;
//public static final int Ph_REGION_INPUT_GROUP                                 = 0x00008000;
//public static final int Ph_REGION_ORIGIN                                      = 0x00000040;
//public static final int Ph_REGION_OWNER                                       = 0x00000001;
//public static final int Ph_REGION_PARENT                                      = 0x00000080;
//public static final int Ph_REGION_RECT                                        = 0x00000400;
//public static final int Ph_REGION_STATE                                       = 0x00000020;
//public static final int Ph_REGION_TYPE_MASK                                   = 0x000FFFFF;
//public static final int Ph_RELEASE_GHOST_BITMAP                               = 0x08;
//public static final int Ph_RELEASE_IMAGE                                      = 0x01;
//public static final int Ph_RELEASE_IMAGE_ALL                                  = 0x0F;
//public static final int Ph_RELEASE_PALETTE                                    = 0x02;
//public static final int Ph_RELEASE_TRANSPARENCY_MASK                          = 0x04;
	public static final int Ph_RESIZE_MSG                                         = 3;
//public static final int Ph_RIDQUERY_IG_POINTER                                = 0x1000;
//public static final int Ph_RIDQUERY_TOWARD                                    = 0x2000;
//public static final int Ph_ROOT_RID                                           = 0;
//public static final int Ph_START_DRAW                                         = 0x4000;
//public static final int Ph_SUPRESS_PARENT_CLIP                                = 0x00000004;
//public static final int Ph_SYNC_GCS                                           = 0x00000008;
//public static final int Ph_SYSTEM_CON_SWITCHABS                               = 0x0101;
//public static final int Ph_SYSTEM_CON_SWITCHREL                               = 0x0102;
//public static final int Ph_SYSTEM_GRAPHIC_ROTATE                              = 0x0201;
//public static final int Ph_SYSTEM_GRAPHIC_ZOOM                                = 0x0202;
//public static final int Ph_SYSTEM_MOUSE_ACCEL                                 = 0x0342;
//public static final int Ph_SYSTEM_MOUSE_DCLICK                                = 0x0341;
//public static final int Ph_SYSTEM_NEWMANAGER                                  = 0x0002;
//public static final int Ph_SYSTEM_PTR_REGION_CHANGE                           = 0x0301;
//public static final int Ph_SYSTEM_REGION_CHANGE                               = 0x0004;
//public static final int Ph_SYSTEM_ROTATE                                      = 0x0003;
//public static final int Ph_SYSTEM_SHUTDOWN                                    = 0x0001;
//public static final int Ph_TEXT_EXTENTS                                       = 0x00000002;
	public static final int Ph_TRACK_BOTTOM                                       = 0x0008;
	public static final int Ph_TRACK_LEFT                                         = 0x0001;
	public static final int Ph_TRACK_RIGHT                                        = 0x0002;
	public static final int Ph_TRACK_TOP                                          = 0x0004;
	public static final int Ph_TRACK_DRAG                                         = (Ph_TRACK_LEFT|Ph_TRACK_RIGHT|Ph_TRACK_TOP|Ph_TRACK_BOTTOM);
//public static final int Ph_TYPE_SPECIFIC                                      = 0x0FF0;
//public static final int Ph_USER_RSRVD_BITS                                    = 0xF000;
//public static final int Ph_WINDOW_REGION                                      = 0x00000001;
//public static final int Ph_WM_ALL_FLAGS                                       = 0x00003F3D;
//
//public static final int Ph_WM_BACKDROP                                        = 0x00001000;
	public static final int Ph_WM_CLOSE                                           = 0x00000001;
//public static final int Ph_WM_CONSWITCH                                       = 0x00000080;
//public static final int Ph_WM_EVSTATE_DEICONIFY                               = 1;
//public static final int Ph_WM_EVSTATE_FFRONT                                  = 0;
//public static final int Ph_WM_EVSTATE_FFRONT_DISABLE                          = 1;
	public static final int Ph_WM_EVSTATE_FOCUS                                   = 0;
	public static final int Ph_WM_EVSTATE_FOCUSLOST                               = 1;
	public static final int Ph_WM_EVSTATE_HIDE                                    = 0;
//	public static final int Ph_WM_EVSTATE_ICONIFY                                 = 0;
//public static final int Ph_WM_EVSTATE_INVERSE                                 = 1;
//public static final int Ph_WM_EVSTATE_MENU                                    = 0;
//public static final int Ph_WM_EVSTATE_MENU_FINISH                             = 1;
//public static final int Ph_WM_EVSTATE_PERFORM                                 = 0;
	public static final int Ph_WM_EVSTATE_UNHIDE                                  = 1;
//public static final int Ph_WM_FFRONT                                          = 0x00010000;
	public static final int Ph_WM_FOCUS                                           = 0x00000004;
	public static final int Ph_WM_HELP                                            = 0x00002000;
	public static final int Ph_WM_HIDE                                            = 0x00000040;
	public static final int Ph_WM_ICON                                            = 0x00000400;
	public static final int Ph_WM_MAX                                             = 0x00000800;
//public static final int Ph_WM_MENU                                            = 0x00000008;
	public static final int Ph_WM_MOVE                                            = 0x00000200;
//public static final int Ph_WM_RENDER_ASAPP                                    = 0x00000000;
//public static final int Ph_WM_RENDER_ASICON                                   = 0x00000001;
//public static final int Ph_WM_RENDER_ASMASK                                   = 0x0000000F;
	public static final int Ph_WM_RENDER_BORDER                                   = 0x00000010;
//public static final int Ph_WM_RENDER_CLOSE                                    = 0x00000200;
//public static final int Ph_WM_RENDER_HELP                                     = 0x00000400;
	public static final int Ph_WM_RENDER_MAX                                      = 0x00002000;
	public static final int Ph_WM_RENDER_MENU                                     = 0x00000100;
	public static final int Ph_WM_RENDER_MIN                                      = 0x00001000;
//public static final int Ph_WM_RENDER_MOVE                                     = 0x00000040;
	public static final int Ph_WM_RENDER_RESIZE                                   = 0x00000020;
//public static final int Ph_WM_RENDER_RETURN                                   = 0x00008000;
	public static final int Ph_WM_RENDER_TITLE                                    = 0x00000080;
	public static final int Ph_WM_RESIZE                                          = 0x00000100;
	public static final int Ph_WM_RESTORE                                         = 0x00008000;
//public static final int Ph_WM_SET_CHILD_COUNT                                 = 0x0200;
//public static final int Ph_WM_SET_CONVERSE_LINK                               = 0x8000;
//public static final int Ph_WM_SET_FLAGS                                       = 0x0001;
//public static final int Ph_WM_SET_FRAME_ATTRIB                                = 0x0400;
//public static final int Ph_WM_SET_FRONT_WINDOW                                = 0x0800;
//public static final int Ph_WM_SET_ICON_POS                                    = 0x0040;
//public static final int Ph_WM_SET_ICON_SIZE                                   = 0x0020;
//public static final int Ph_WM_SET_ICON_TITLE                                  = 0x0010;
//public static final int Ph_WM_SET_LINK                                        = 0x0080;
//public static final int Ph_WM_SET_RELATION                                    = 0x0100;
//public static final int Ph_WM_SET_RENDER                                      = 0x0004;
//public static final int Ph_WM_SET_STATE                                       = 0x0002;
//public static final int Ph_WM_SET_TITLE                                       = 0x0008;
//public static final int Ph_WM_STATE_ISALTKEY                                  = 0x00000200;
//public static final int Ph_WM_STATE_ISBACKDROP                                = 0x00000004;
//public static final int Ph_WM_STATE_ISBLOCKED                                 = 0x00000008;
	public static final int Ph_WM_STATE_ISFOCUS                                   = 0x00008000;
	public static final int Ph_WM_STATE_ISFRONT                                   = 0x00000100;
	public static final int Ph_WM_STATE_ISHIDDEN                                  = 0x00000001;
//public static final int Ph_WM_STATE_ISICON                                    = 0x00000080;
	public static final int Ph_WM_STATE_ISICONIFIED                               = 0x00000040;
//public static final int Ph_WM_STATE_ISMASK                                    = 0x0000FFFF;
	public static final int Ph_WM_STATE_ISMAX                                     = 0x00000002;
	public static final int Ph_WM_STATE_ISMAXING                                  = 0x00004000;
//public static final int Ph_WM_STATE_ISNORMAL                                  = 0x00000000;
//public static final int Ph_WM_STATE_ISPDM                                     = 0x00000020;
//public static final int Ph_WM_STATE_ISREMOTE                                  = 0x00000400;
//public static final int Ph_WM_STATE_ISTASKBAR                                 = 0x00000010;
//public static final int Ph_WM_SUPERSELECT                                     = ~0;
//public static final int Ph_WM_TASKBAR                                         = 0x00004000;
//public static final int Ph_WM_TERMINATE                                       = 0x00000002;
//public static final int Ph_WM_TOBACK                                          = 0x00000020;
//public static final int Ph_WM_TOFRONT                                         = 0x00000010;
//public static final int Ph_WND_MGR_REGION                                     = 0x00000002;
//public static final int PHF_STATS                                             = 0x01;
	public static final int PHFONT_ALL_FONTS                                      = 0x33;
	public static final int PHFONT_ALL_SYMBOLS                                    = (-1);
	public static final int PHFONT_BITMAP                                         = 0x02;
	public static final int PHFONT_FIXED                                          = 0x20;
	public static final int PHFONT_INFO_BLDITC                                    = 0x08;
	public static final int PHFONT_INFO_BOLD                                      = 0x02;
	public static final int PHFONT_INFO_FIXED                                     = 0x10;
	public static final int PHFONT_INFO_ITALIC                                    = 0x04;
	public static final int PHFONT_INFO_PLAIN                                     = 0x01;
	public static final int PHFONT_INFO_PROP                                      = 0x20;
//public static final int PHFONT_LOAD_IMAGES                                    = 0x02;
//public static final int PHFONT_LOAD_METRICS                                   = 0x01;
//public static final int PHFONT_MSG_ANTIALIAS                                  = 12;
//public static final int PHFONT_MSG_CEXTENT1                                   = 6;
//public static final int PHFONT_MSG_CEXTENT2                                   = 14;
//public static final int PHFONT_MSG_DYNAMIC_LOAD                               = 0x1000;
//public static final int PHFONT_MSG_DYNAMIC_UNLOAD                             = 0x1001;
//public static final int PHFONT_MSG_EXTENT                                     = 5;
//public static final int PHFONT_MSG_FEXTENT                                    = 18;
//public static final int PHFONT_MSG_FEXTENT_WIDE                               = 26;
//public static final int PHFONT_MSG_FRENDER                                    = 19;
//public static final int PHFONT_MSG_FRENDER2                                   = 20;
//public static final int PHFONT_MSG_FRENDER_WIDE                               = 25;
//public static final int PHFONT_MSG_FRENDER_WIDE2                              = 27;
//public static final int PHFONT_MSG_GLYPH                                      = 9;
//public static final int PHFONT_MSG_LIST                                       = 3;
//public static final int PHFONT_MSG_LOAD                                       = 2;
//public static final int PHFONT_MSG_LOCAL1                                     = 10;
//public static final int PHFONT_MSG_LOCAL2                                     = 11;
//public static final int PHFONT_MSG_LOCAL2_V20                                 = 31;
//public static final int PHFONT_MSG_QUERY                                      = 4;
//public static final int PHFONT_MSG_RENDER                                     = 7;
//public static final int PHFONT_MSG_RENDER2                                    = 13;
//public static final int PHFONT_MSG_SHMEM                                      = 8;
//public static final int PHFONT_MSG_STAT_PFR                                   = 29;
//public static final int PHFONT_MSG_STAT_PHF                                   = 28;
//public static final int PHFONT_MSG_STAT_TTF                                   = 30;
//public static final int PHFONT_MSG_WEXTENT                                    = 15;
//public static final int PHFONT_MSG_WRENDER                                    = 16;
//public static final int PHFONT_MSG_WRENDER2                                   = 17;
	public static final int PHFONT_PROP                                           = 0x10;
	public static final int PHFONT_SCALABLE                                       = 0x01;
//
	public static final int Pk_KF_Key_Down         = 0x00000001;
	public static final int Pk_KF_Key_Repeat       = 0x00000002;
	public static final int Pk_KF_Scan_Valid       = 0x00000020;
	public static final int Pk_KF_Sym_Valid        = 0x00000040;
	public static final int Pk_KF_Cap_Valid        = 0x00000080;
//public static final int Pk_KF_Compose          = 0x40000000;
	public static final int Pk_KM_Shift            = 0x00000001;
	public static final int Pk_KM_Ctrl             = 0x00000002;
	public static final int Pk_KM_Alt              = 0x00000004;
//public static final int Pk_KM_AltGr            = 0x00000008;
//public static final int Pk_KM_Shl3             = 0x00000010;
//
//public static final int Pk_KM_Shift_Lock       = 0x00000100;
//public static final int Pk_KM_Ctrl_Lock        = 0x00000200;
//public static final int Pk_KM_Alt_Lock         = 0x00000400;
//public static final int Pk_KM_AltGr_Lock       = 0x00000800;
//
//public static final int Pk_KM_Caps_Lock        = 0x00010000;
//public static final int Pk_KM_Num_Lock         = 0x00020000;
//public static final int Pk_KM_Scroll_Lock      = 0x00040000;
//
//
	public static final int Pk_BackSpace           = 0xF008;  /* back space, back char */
	public static final int Pk_Tab                 = 0xF009;
	public static final int Pk_Linefeed            = 0xF00A;  /* Linefeed, LF */
	public static final int Pk_Clear               = 0xF00B;
	public static final int Pk_Return              = 0xF00D;  /* Return, enter */
	public static final int Pk_Pause               = 0xF013;  /* Pause, hold */
	public static final int Pk_Scroll_Lock         = 0xF014;
	public static final int Pk_Escape              = 0xF01B;
	public static final int Pk_Delete              = 0xF0FF;  /* Delete, rubout */
//
//public static final int Pk_Multi_key           = 0xF020; /* Multi-key character compose */
//
//public static final int Pk_Kanji               = 0xF021;  /* Kanji, Kanji convert */
//public static final int Pk_Muhenkan            = 0xF022; /* Cancel Conversion */
//public static final int Pk_Henkan_Mode         = 0xF023; /* Start/Stop Conversion */
//public static final int Pk_Henkan              = 0xF023; /* Alias for Henkan_Mode */
//public static final int Pk_Romaji              = 0xF024; /* to Romaji */
//public static final int Pk_Hiragana            = 0xF025; /* to Hiragana */
//public static final int Pk_Katakana            = 0xF026; /* to Katakana */
//public static final int Pk_Hiragana_Katakana   = 0xF027; /* Hiragana/Katakana toggle */
//public static final int Pk_Zenkaku             = 0xF028; /* to Zenkaku */
//public static final int Pk_Hankaku             = 0xF029; /* to Hankaku */
//public static final int Pk_Zenkaku_Hankaku     = 0xF02A; /* Zenkaku/Hankaku toggle */
//public static final int Pk_Touroku             = 0xF02B; /* Add to Dictionary */
//public static final int Pk_Massyo              = 0xF02C; /* Delete from Dictionary */
//public static final int Pk_Kana_Lock           = 0xF02D; /* Kana Lock */
//public static final int Pk_Kana_Shift          = 0xF02E; /* Kana Shift */
//public static final int Pk_Eisu_Shift          = 0xF02F; /* Alphanumeric Shift */
//public static final int Pk_Eisu_toggle         = 0xF030; /* Alphanumeric toggle */
//
	public static final int Pk_Home                = 0xF050;
	public static final int Pk_Left                = 0xF051;  /* Move left, left arrow */
	public static final int Pk_Up                  = 0xF052;  /* Move up, up arrow */
	public static final int Pk_Right               = 0xF053;  /* Move right, right arrow */
	public static final int Pk_Down                = 0xF054;  /* Move down, down arrow */
	public static final int Pk_Prior               = 0xF055;  /* Prior, previous */
	public static final int Pk_Pg_Up               = 0xF055;  /* Prior, previous */
	public static final int Pk_Next                = 0xF056;  /* Next */
	public static final int Pk_Pg_Down             = 0xF056;  /* Next */
	public static final int Pk_End                 = 0xF057;  /* EOL */
//public static final int Pk_Begin               = 0xF058;  /* BOL */
//
//public static final int Pk_Select              = 0xF060;  /* Select, mark */
//public static final int Pk_Print               = 0xF061;
//public static final int Pk_Execute             = 0xF062;  /* Execute, run, do */
	public static final int Pk_Insert              = 0xF063;  /* Insert, insert here */
//public static final int Pk_Undo                = 0xF065;  /* Undo, oops */
//public static final int Pk_Redo                = 0xF066;  /* redo, again */
//public static final int Pk_Menu                = 0xF067;
//public static final int Pk_Find                = 0xF068;  /* Find, search */
	public static final int Pk_Cancel              = 0xF069;  /* Cancel, stop, abort, exit */
//public static final int Pk_Help                = 0xF06A;  /* Help, ? */
//public static final int Pk_Break               = 0xF06B;
//public static final int Pk_Mode_switch         = 0xF07E;  /* Character set switch */
//public static final int Pk_script_switch       = 0xF07E; /* Alias for mode_switch */
//public static final int Pk_Num_Lock            = 0xF07F;
//
//public static final int Pk_KP_Space            = 0xF080;  /* space */
	public static final int Pk_KP_Tab              = 0xF089;
//public static final int Pk_KP_Enter            = 0xF08D;  /* enter */
//public static final int Pk_KP_F1               = 0xF091;  /* PF1, KP_A, ... */
//public static final int Pk_KP_F2               = 0xF092;
//public static final int Pk_KP_F3               = 0xF093;
//public static final int Pk_KP_F4               = 0xF094;
//public static final int Pk_KP_Equal            = 0xF0BD;  /* equals */
//public static final int Pk_KP_Multiply         = 0xF0AA;
//public static final int Pk_KP_Add              = 0xF0AB;
//public static final int Pk_KP_Separator        = 0xF0AC;  /* separator, often comma */
//public static final int Pk_KP_Subtract         = 0xF0AD;
//public static final int Pk_KP_Decimal          = 0xF0AE;
//public static final int Pk_KP_Divide           = 0xF0AF;
//
//public static final int Pk_KP_0                = 0xF0B0;
//public static final int Pk_KP_1                = 0xF0B1;
//public static final int Pk_KP_2                = 0xF0B2;
//public static final int Pk_KP_3                = 0xF0B3;
//public static final int Pk_KP_4                = 0xF0B4;
//public static final int Pk_KP_5                = 0xF0B5;
//public static final int Pk_KP_6                = 0xF0B6;
//public static final int Pk_KP_7                = 0xF0B7;
//public static final int Pk_KP_8                = 0xF0B8;
//public static final int Pk_KP_9                = 0xF0B9;
//
	public static final int Pk_F1                  = 0xF0BE;
	public static final int Pk_F2                  = 0xF0BF;
	public static final int Pk_F3                  = 0xF0C0;
	public static final int Pk_F4                  = 0xF0C1;
	public static final int Pk_F5                  = 0xF0C2;
	public static final int Pk_F6                  = 0xF0C3;
	public static final int Pk_F7                  = 0xF0C4;
	public static final int Pk_F8                  = 0xF0C5;
	public static final int Pk_F9                  = 0xF0C6;
	public static final int Pk_F10                 = 0xF0C7;
	public static final int Pk_F11                 = 0xF0C8;
	public static final int Pk_F12                 = 0xF0C9;
//
	public static final int Pk_Shift_L             = 0xF0E1;  /* Left shift */
	public static final int Pk_Shift_R             = 0xF0E2;  /* Right shift */
	public static final int Pk_Control_L           = 0xF0E3;  /* Left control */
	public static final int Pk_Control_R           = 0xF0E4;  /* Right control */
//public static final int Pk_Caps_Lock           = 0xF0E5;  /* Caps lock */
//public static final int Pk_Shift_Lock          = 0xF0E6;  /* Shift lock */
//
//public static final int Pk_Meta_L              = 0xF0E7;  /* Left meta */
//public static final int Pk_Meta_R              = 0xF0E8;  /* Right meta */
	public static final int Pk_Alt_L               = 0xF0E9;  /* Left alt */
	public static final int Pk_Alt_R               = 0xF0EA;  /* Right alt */
//
//public static final int Pm_CONTEXT_FLUSHED                                    = 0x00000001;
//public static final int Pm_IMAGE_CONTEXT                                      = 1;
//public static final int Pm_PHS_CONTEXT                                        = 0;
//public static final int POINTER_CTRL_ATTR_MASK                                = 0x00000f00;
//public static final int POINTER_CTRL_BUTTONS                                  = 0x00000010;
//public static final int POINTER_CTRL_DEVMATRIX                                = 0x00000200;
//public static final int POINTER_CTRL_FILENAME                                 = 0x00000080;
//public static final int POINTER_CTRL_GAIN                                     = 0x00000004;
//public static final int POINTER_CTRL_GETCTRL                                  = 0x00000000;
//public static final int POINTER_CTRL_GETMATRIX                                = 0x00000040;
//public static final int POINTER_CTRL_LAYER                                    = 0x00000800;
//public static final int POINTER_CTRL_LAYER_MASK                               = DEV_CTRL_LAYER_MASK;
//public static final int POINTER_CTRL_OFF                                      = 0x00000002;
//public static final int POINTER_CTRL_ON                                       = 0x00000001;
//public static final int POINTER_CTRL_SCRNMATRIX                               = 0x00000400;
//public static final int POINTER_CTRL_SETMATRIX                                = 0x00000020;
//public static final int POINTER_CTRL_SWAP                                     = 0x00000100;
//public static final int POINTER_CTRL_SWITCH_MASK                              = DEV_CTRL_SWITCH_MASK;
//public static final int POINTER_CTRL_THRESHOLD                                = 0x00000008;
//public static final int POINTER_CTRL_TYPE_MASK                                = DEV_CTRL_TYPE_MASK;
//public static final int Pp_DOCUMENT_COMPLETE                                  = 0x00000001;
//public static final int Pp_LANDSCAPE                                          = 1;
//public static final int Pp_LANDSCAPE_TSHIRT                                   = 3;
//public static final int Pp_PAGE_COMPLETE                                      = 0x00000002;
//public static final int Pp_PORTRAIT                                           = 0;
//public static final int Pp_TSHIRT                                             = 2;
//public static final int Pt_ALIGN_BOTTOM                                       = 0x20;
//public static final int Pt_ALIGN_CENTER                                       = 0x2;
//public static final int Pt_ALIGN_LEFT                                         = 0x40;
//public static final int Pt_ALIGN_RIGHT                                        = 0x80;
//public static final int Pt_ALIGN_TOP                                          = 0x10;
//public static final int Pt_ALL_BUTTONS                                        = 0x00800000;
	public static final int Pt_ALWAYS                                             = 0x01;
//public static final int Pt_ANCHORS_INVALID                                    = 0x40000000;
	public static final int Pt_ANCHORS_LOCKED                                     = 0x04000000;
//public static final int Pt_ARC_CHORD                                          = Pg_ARC_CHORD;
//public static final int Pt_ARC_CURVE                                          = Pg_ARC;
//public static final int Pt_ARC_PIE                                            = Pg_ARC_PIE;
//public static final int Pt_ARG_ACCEL_FONT                                     = ( 7 * 1000 + 1 );
	public static final int Pt_ARG_ACCEL_KEY                                      = ( 3 * 1000 + 18 );
	public static final int Pt_ARG_ACCEL_TEXT                                     = ( 7 * 1000 + 0 );
	public static final int Pt_ARG_ANCHOR_FLAGS                                   = ( 10 * 1000 + 1 );
//public static final int Pt_ARG_ANCHOR_OFFSETS                                 = ( 10 * 1000 + 0 );
//public static final int Pt_ARG_ARC_END                                        = ( 26 * 1000 + 0 );
//public static final int Pt_ARG_ARC_START                                      = ( 26 * 1000 + 1 );
//public static final int Pt_ARG_ARC_TYPE                                       = ( 26 * 1000 + 2 );
	public static final int Pt_ARG_AREA                                           = ( 1 * 1000 + 0 );
	public static final int Pt_ARG_ARM_COLOR                                      = ( 6 * 1000 + 0 );
//public static final int Pt_ARG_ARM_DATA                                       = ( 6 * 1000 + 1 );
	public static final int Pt_ARG_ARM_FILL                                       = ( 6 * 1000 + 2 );
	public static final int Pt_ARG_BALLOON_COLOR                                  = ( 3 * 1000 + 20 );
	public static final int Pt_ARG_BALLOON_FILL_COLOR                             = ( 3 * 1000 + 19 );
	public static final int Pt_ARG_BALLOON_POSITION                               = ( 3 * 1000 + 16 );
//public static final int Pt_ARG_BANDWIDTH_THRESHOLD                            = ( 2 * 1000 + 17 );
	public static final int Pt_ARG_BASIC_FLAGS                                    = ( 2 * 1000 + 15 );
//public static final int Pt_ARG_BEZIER_FLAGS                                   = ( 42 * 1000 + 1 );
//public static final int Pt_ARG_BITMAP_BALLOON                                 = ( 20 * 1000 + 9 );
//public static final int Pt_ARG_BITMAP_BALLOON_COLOR                           = ( 20 * 1000 + 11 );
//public static final int Pt_ARG_BITMAP_BALLOON_FILL_COLOR                      = ( 20 * 1000 + 10 );
//public static final int Pt_ARG_BITMAP_BALLOON_POSITION                        = ( 20 * 1000 + 8 );
//public static final int Pt_ARG_BITMAP_COLORS                                  = ( 20 * 1000 + 0 );
	public static final int Pt_ARG_BITMAP_CURSOR                                  = ( 1 * 1000 + 17 );
//public static final int Pt_ARG_BITMAP_DATA                                    = ( 20 * 1000 + 1 );
//public static final int Pt_ARG_BITMAP_FLAGS                                   = ( 20 * 1000 + 7 );
//public static final int Pt_ARG_BITMAP_TEXT                                    = ( 20 * 1000 + 2 );
//public static final int Pt_ARG_BKGD_BRT_FROM                                  = ( 14 * 1000 + 0 );
//public static final int Pt_ARG_BKGD_BRT_TO                                    = ( 14 * 1000 + 1 );
//public static final int Pt_ARG_BKGD_HUE_FROM                                  = ( 14 * 1000 + 2 );
//public static final int Pt_ARG_BKGD_HUE_TO                                    = ( 14 * 1000 + 3 );
//public static final int Pt_ARG_BKGD_IMAGE                                     = ( 14 * 1000 + 15 );
//public static final int Pt_ARG_BKGD_MIX                                       = ( 14 * 1000 + 4 );
//public static final int Pt_ARG_BKGD_ORIENTATION                               = ( 14 * 1000 + 5 );
//public static final int Pt_ARG_BKGD_PIX_HEIGHT                                = ( 14 * 1000 + 8 );
//public static final int Pt_ARG_BKGD_PIX_WIDTH                                 = ( 14 * 1000 + 9 );
//public static final int Pt_ARG_BKGD_PIXCOLORS                                 = ( 14 * 1000 + 6 );
//public static final int Pt_ARG_BKGD_PIXMAP                                    = ( 14 * 1000 + 7 );
//public static final int Pt_ARG_BKGD_SAT_FROM                                  = ( 14 * 1000 + 10 );
//public static final int Pt_ARG_BKGD_SAT_TO                                    = ( 14 * 1000 + 11 );
//public static final int Pt_ARG_BKGD_SPACING                                   = ( 14 * 1000 + 16 );
//public static final int Pt_ARG_BKGD_STEPS                                     = ( 14 * 1000 + 12 );
//public static final int Pt_ARG_BKGD_TILE                                      = ( 14 * 1000 + 13 );
//public static final int Pt_ARG_BKGD_TYPE                                      = ( 14 * 1000 + 14 );
//public static final int Pt_ARG_BMP_SET_BG_COLOR                               = ( 20 * 1000 + 3 );
//public static final int Pt_ARG_BMP_SET_BG_FILL                                = ( 20 * 1000 + 4 );
	public static final int Pt_ARG_BORDER_WIDTH                                   = ( 1 * 1000 + 1 );
//public static final int Pt_ARG_BOT_BORDER_COLOR                               = ( 2 * 1000 + 0 );
	public static final int Pt_ARG_BUTTON_TYPE                                    = ( 7 * 1000 + 2 );
//public static final int Pt_ARG_CALENDAR_COLOR1                                = ( 56 * 1000 +  2 );
//public static final int Pt_ARG_CALENDAR_COLOR2                                = ( 56 * 1000 +  4 );
//public static final int Pt_ARG_CALENDAR_COLOR3                                = ( 56 * 1000 +  6 );
//public static final int Pt_ARG_CALENDAR_COLOR4                                = ( 56 * 1000 +  8 );
//public static final int Pt_ARG_CALENDAR_COLOR5                                = ( 56 * 1000 + 10 );
//public static final int Pt_ARG_CALENDAR_DATE                                  = ( 56 * 1000 +  0 );
//public static final int Pt_ARG_CALENDAR_FLAGS                                 = ( 56 * 1000 + 14 );
//public static final int Pt_ARG_CALENDAR_FONT1                                 = ( 56 * 1000 +  1 );
//public static final int Pt_ARG_CALENDAR_FONT2                                 = ( 56 * 1000 +  3 );
//public static final int Pt_ARG_CALENDAR_FONT3                                 = ( 56 * 1000 +  5 );
//public static final int Pt_ARG_CALENDAR_FONT4                                 = ( 56 * 1000 +  7 );
//public static final int Pt_ARG_CALENDAR_FONT5                                 = ( 56 * 1000 +  9 );
//public static final int Pt_ARG_CALENDAR_HIGHLIGHT                             = ( 56 * 1000 + 15 );
//public static final int Pt_ARG_CALENDAR_MONTH_BTN_COLOR                       = ( 56 * 1000 + 19 );
//public static final int Pt_ARG_CALENDAR_MONTH_NAMES                           = ( 56 * 1000 + 13 );
//public static final int Pt_ARG_CALENDAR_SEL_COLOR                             = ( 56 * 1000 + 11 );
//public static final int Pt_ARG_CALENDAR_TIME_T                                = ( 56 * 1000 + 17 );
//public static final int Pt_ARG_CALENDAR_WDAY_NAMES                            = ( 56 * 1000 + 12 );
//public static final int Pt_ARG_CALENDAR_YEAR_BTN_COLOR                        = ( 56 * 1000 + 18 );
//public static final int Pt_ARG_CBOX_BUTTON_BORDER_WIDTH                       = ( 31 * 1000 + 15 );
//public static final int Pt_ARG_CBOX_BUTTON_BOT_BORDER_COLOR                   = ( 31 * 1000 + 17 );
//public static final int Pt_ARG_CBOX_BUTTON_COLOR                              = ( 31 * 1000 + 18 );
//public static final int Pt_ARG_CBOX_BUTTON_TOP_BORDER_COLOR                   = ( 31 * 1000 + 16 );
//public static final int Pt_ARG_CBOX_BUTTON_WIDTH                              = ( 31 * 1000 + 6 );
	public static final int Pt_ARG_CBOX_FLAGS                                     = ( 31 * 1000 + 0 );
	public static final int Pt_ARG_CBOX_MAX_VISIBLE_COUNT                         = ( 31 * 1000 + 19);
//public static final int Pt_ARG_CBOX_SEL_ITEM                                  = ( 31 * 1000 + 1 );
	public static final int Pt_ARG_CBOX_SELECTION_ITEM                            = ( 31 * 1000 + 1 );
//public static final int Pt_ARG_CLIENT_FLAGS                                   = ( 99 * 1000 +  7 );
//public static final int Pt_ARG_CLIENT_NAME                                    = ( 99 * 1000 +  4 );
//public static final int Pt_ARG_CLIENT_REPLY_LEN                               = ( 99 * 1000 +  2 );
//public static final int Pt_ARG_CLIENT_SEND                                    = ( 99 * 1000 +  1 );
//public static final int Pt_ARG_CLIENT_SERVER                                  = ( 99 * 1000 +  0 );
//public static final int Pt_ARG_CLOCK_FACE_COLOR                               = (57 * 1000 +6);
//public static final int Pt_ARG_CLOCK_FACE_OUTLINE_COLOR                       = (57 * 1000 +5);
//public static final int Pt_ARG_CLOCK_FLAGS                                    = (57 * 1000 +1);
//public static final int Pt_ARG_CLOCK_FONT                                     = (57 * 1000 +17);
//public static final int Pt_ARG_CLOCK_HOUR                                     = (57 * 1000 +2);
//public static final int Pt_ARG_CLOCK_HOUR_COLOR                               = (57 * 1000 +7);
//public static final int Pt_ARG_CLOCK_HOUR_OFFSET                              = (57 * 1000 +14);
//public static final int Pt_ARG_CLOCK_MINUTE                                   = (57 * 1000 +3);
//public static final int Pt_ARG_CLOCK_MINUTE_COLOR                             = (57 * 1000 +8);
//public static final int Pt_ARG_CLOCK_MINUTE_OFFSET                            = (57 * 1000 +15);
//public static final int Pt_ARG_CLOCK_SECOND                                   = (57 * 1000 +4);
//public static final int Pt_ARG_CLOCK_SECOND_COLOR                             = (57 * 1000 +9);
//public static final int Pt_ARG_CLOCK_SECOND_OFFSET                            = (57 * 1000 +16);
//public static final int Pt_ARG_CLOCK_SEP1                                     = (57 * 1000 +10);
//public static final int Pt_ARG_CLOCK_SEP1_COLOR                               = (57 * 1000 +12);
//public static final int Pt_ARG_CLOCK_SEP2                                     = (57 * 1000 +11);
//public static final int Pt_ARG_CLOCK_SEP2_COLOR                               = (57 * 1000 +13);
//public static final int Pt_ARG_CLOCK_TYPE                                     = (57 * 1000 +0);
	public static final int Pt_ARG_COLOR                                          = ( 2 * 1000 + 1 );
//public static final int Pt_ARG_COLUMNS                                        = ( 4 * 1000 + 1 );
	public static final int Pt_ARG_CONTAINER_FLAGS                                = ( 10 * 1000 + 5 );
//public static final int Pt_ARG_CURRENT_FRAME                                  = ( 101 * 1000 + 3 );
	public static final int Pt_ARG_CURSOR_COLOR                                   = ( 1 * 1000 + 3 );
//public static final int Pt_ARG_CURSOR_OFFSET                                  = ( 4 * 1000 + 19);
	public static final int Pt_ARG_CURSOR_POSITION                                = ( 4 * 1000 + 3 );
	public static final int Pt_ARG_CURSOR_TYPE                                    = ( 1 * 1000 + 2 );
//public static final int Pt_ARG_DASH_LIST                                      = ( 25 * 1000 + 0 );
//public static final int Pt_ARG_DASH_SCALE                                     = ( 25 * 1000 + 8 );
//public static final int Pt_ARG_DATA                                           = ( 1 * 1000 + 4 );
//public static final int Pt_ARG_DB_IMAGE_TYPE                                  = ( 48 * 1000 + 0 );
//public static final int Pt_ARG_DB_MEMORY_CONTEXT_TYPE                         = ( 48 * 1000 + 1 );
//public static final int Pt_ARG_DEFAULT_ACTION                                 = ( 18 * 1000 + 0 );
	public static final int Pt_ARG_DIM                                            = ( 1 * 1000 + 5 );
//public static final int Pt_ARG_DIRECTION                                      = ( 29 * 1000 + 0 );
//public static final int Pt_ARG_DIVIDER_FLAGS                                  = ( 44 * 1000 +  1 );
//public static final int Pt_ARG_DIVIDER_OFFSET                                 = ( 44 * 1000 +  4 );
//public static final int Pt_ARG_DIVIDER_SIZES                                  = ( 44 * 1000 +  2 );
//public static final int Pt_ARG_EDIT_MASK                                      = ( 4 * 1000 + 4 );
//public static final int Pt_ARG_EFLAGS                                         = ( 1 * 1000 + 18 );
//public static final int Pt_ARG_EXTENDED_SHIFT                                 = 20;
//public static final int Pt_ARG_EXTENDED_TYPES_MASK                            = 0x00300000;
	public static final int Pt_ARG_FILL_COLOR                                     = ( 2 * 1000 + 2 );
//public static final int Pt_ARG_FILL_PATTERN                                   = ( 2 * 1000 + 3 );
	public static final int Pt_ARG_FLAGS                                          = ( 1 * 1000 + 6 );
//public static final int Pt_ARG_FOCUS                                          = ( 10 * 1000 + 2 );
//public static final int Pt_ARG_FONT_DISPLAY                                   = (38 * 1000 + 5);
//public static final int Pt_ARG_FONT_FLAGS                                     = (38 * 1000 + 3);
//public static final int Pt_ARG_FONT_NAME                                      = (38 * 1000 + 0);
//public static final int Pt_ARG_FONT_SAMPLE                                    = (38 * 1000 + 1);
//public static final int Pt_ARG_FONT_SYMBOL                                    = (38 * 1000 + 2);
//public static final int Pt_ARG_FRAME_DATA                                     = ( 101 * 1000 + 0 );
//public static final int Pt_ARG_FRAME_INTERVAL                                 = ( 101 * 1000 + 2 );
//public static final int Pt_ARG_FS_FILE_SPEC                                   = ( 47 * 1000 + 5 );
//public static final int Pt_ARG_FS_FLAGS                                       = ( 47 * 1000 + 2 );
//public static final int Pt_ARG_FS_FORMAT                                      = ( 47 * 1000 + 5 );
//public static final int Pt_ARG_FS_IMAGES                                      = ( 47 * 1000 + 1 );
//public static final int Pt_ARG_FS_REFRESH                                     = ( 47 * 1000 + 3 );
//public static final int Pt_ARG_FS_ROOT_DIR                                    = ( 47 * 1000 + 0 );
//public static final int Pt_ARG_FS_TIMER_INITIAL                               = ( 47 * 1000 + 4 );
	public static final int Pt_ARG_GAUGE_FLAGS                                    = ( 21 * 1000 + 0 );
	public static final int Pt_ARG_GAUGE_FONT                                     = ( 21 * 1000 + 1 );
//public static final int Pt_ARG_GAUGE_H_ALIGN                                  = ( 21 * 1000 + 8 );
	public static final int Pt_ARG_GAUGE_MAXIMUM                                  = ( 21 * 1000 + 3 );
	public static final int Pt_ARG_GAUGE_MINIMUM                                  = ( 21 * 1000 + 2 );
	public static final int Pt_ARG_GAUGE_ORIENTATION                              = ( 21 * 1000 + 5 );
//public static final int Pt_ARG_GAUGE_V_ALIGN                                  = ( 21 * 1000 + 9 );
	public static final int Pt_ARG_GAUGE_VALUE                                    = ( 21 * 1000 + 4 );
//public static final int Pt_ARG_GAUGE_VALUE_PREFIX                             = ( 21 * 1000 + 6 );
//public static final int Pt_ARG_GAUGE_VALUE_SUFFIX                             = ( 21 * 1000 + 7 );
//public static final int Pt_ARG_GRAPHIC_FLAGS                                  = ( 25 * 1000 + 1 );
//public static final int Pt_ARG_GRID_HORIZONTAL                                = ( 43 * 1000 + 0 );
//public static final int Pt_ARG_GRID_VERTICAL                                  = ( 43 * 1000 + 1 );
	public static final int Pt_ARG_GROUP_FLAGS                                    = ( 11 * 1000 + 0 );
	public static final int Pt_ARG_GROUP_HORZ_ALIGN                               = ( 11 * 1000 + 1 );
	public static final int Pt_ARG_GROUP_ORIENTATION                              = ( 11 * 1000 + 2 );
//public static final int Pt_ARG_GROUP_ROWS_COLS                                = ( 11 * 1000 + 5 );
	public static final int Pt_ARG_GROUP_SPACING                                  = ( 11 * 1000 + 3 );
//public static final int Pt_ARG_GROUP_SPACING_X                                = ( 11 * 1000 + 6 );
//public static final int Pt_ARG_GROUP_SPACING_Y                                = ( 11 * 1000 + 7 );
	public static final int Pt_ARG_GROUP_VERT_ALIGN                               = ( 11 * 1000 + 4 );
//public static final int Pt_ARG_HELP_TOPIC                                     = ( 1 * 1000 + 15 );
//public static final int Pt_ARG_HIGHLIGHT_COLOR                                = ( 4 * 1000 + 15 );
//public static final int Pt_ARG_HIGHLIGHT_ROUNDNESS                            = ( 2 * 1000 + 14 );
	public static final int Pt_ARG_HORIZONTAL_ALIGNMENT                           = ( 3 * 1000 + 0 );
//public static final int Pt_ARG_HTML_BORDER_WIDTH                              = ( 45 * 1000 + 26 );
//public static final int Pt_ARG_HTML_CURSOR_BUSY                               = ( 45 * 1000 + 11 );
//public static final int Pt_ARG_HTML_CURSOR_DEFAULT                            = ( 45 * 1000 + 9 );
//public static final int Pt_ARG_HTML_CURSOR_LINK                               = ( 45 * 1000 + 10 );
//public static final int Pt_ARG_HTML_FILL_COLOR                                = ( 45 * 1000 + 27 );
//public static final int Pt_ARG_HTML_FLAGS                                     = ( 45 * 1000 + 31 );
//public static final int Pt_ARG_HTML_H1_FONT                                   = ( 45 * 1000 + 2 );
//public static final int Pt_ARG_HTML_H2_FONT                                   = ( 45 * 1000 + 3 );
//public static final int Pt_ARG_HTML_H3_FONT                                   = ( 45 * 1000 + 4 );
//public static final int Pt_ARG_HTML_H4_FONT                                   = ( 45 * 1000 + 5 );
//public static final int Pt_ARG_HTML_H5_FONT                                   = ( 45 * 1000 + 6 );
//public static final int Pt_ARG_HTML_H6_FONT                                   = ( 45 * 1000 + 7 );
//public static final int Pt_ARG_HTML_INCREMENT                                 = ( 45 * 1000 + 32 );
//public static final int Pt_ARG_HTML_LINK_COLOR                                = ( 45 * 1000 + 8 );
//public static final int Pt_ARG_HTML_PAGE_BM                                   = ( 45 * 1000 + 24 );
//public static final int Pt_ARG_HTML_PAGE_H                                    = ( 45 * 1000 + 20 );
//public static final int Pt_ARG_HTML_PAGE_INCREMENT                            = ( 45 * 1000 + 33 );
//public static final int Pt_ARG_HTML_PAGE_LM                                   = ( 45 * 1000 + 25 );
//public static final int Pt_ARG_HTML_PAGE_N                                    = ( 45 * 1000 + 35 );
//public static final int Pt_ARG_HTML_PAGE_RM                                   = ( 45 * 1000 + 23 );
//public static final int Pt_ARG_HTML_PAGE_TM                                   = ( 45 * 1000 + 22 );
//public static final int Pt_ARG_HTML_PAGE_W                                    = ( 45 * 1000 + 21 );
//public static final int Pt_ARG_HTML_PAGE_X                                    = ( 45 * 1000 + 18 );
//public static final int Pt_ARG_HTML_PAGE_Y                                    = ( 45 * 1000 + 19 );
//public static final int Pt_ARG_HTML_PAGES                                     = ( 45 * 1000 + 34 );
//public static final int Pt_ARG_HTML_SCROLL_COLOR                              = ( 45 * 1000 + 28 );
//public static final int Pt_ARG_HTML_SCROLL_FILL_COLOR                         = ( 45 * 1000 + 29 );
//public static final int Pt_ARG_HTML_SCROLL_HORIZONTAL                         = ( 45 * 1000 + 13 );
//public static final int Pt_ARG_HTML_SCROLL_VERTICAL                           = ( 45 * 1000 + 12 );
//public static final int Pt_ARG_HTML_SCROLL_WIDTH                              = ( 45 * 1000 + 14 );
//public static final int Pt_ARG_HTML_TEXT_FONT                                 = ( 45 * 1000 + 1 );
//public static final int Pt_ARG_HTML_URL                                       = ( 45 * 1000 + 0 );
//public static final int Pt_ARG_ICON_FLAGS                                     = ( 18 * 1000 + 1 );
//public static final int Pt_ARG_ICON_POS                                       = ( 18 * 1000 + 2 );
//public static final int Pt_ARG_ICON_WINDOW                                    = ( 18 * 1000 + 3 );
//public static final int Pt_ARG_IMAGEAREA_FLAGS                                = ( 103 * 1000 + 8 );
//public static final int Pt_ARG_IMAGEAREA_GRID_COLOR                           = ( 103 * 1000 + 14 );
//public static final int Pt_ARG_IMAGEAREA_GRID_THRESHOLD                       = ( 103 * 1000 + 13 );
//public static final int Pt_ARG_IMAGEAREA_IMAGE                                = ( 103 * 1000 + 0 );
//public static final int Pt_ARG_IMAGEAREA_LEFT                                 = ( 103 * 1000 + 6 );
//public static final int Pt_ARG_IMAGEAREA_SELECTION                            = ( 103 * 1000 + 12 );
//public static final int Pt_ARG_IMAGEAREA_TOP                                  = ( 103 * 1000 + 5 );
//public static final int Pt_ARG_IMAGEAREA_ZOOM                                 = ( 103 * 1000 + 7 );
//public static final int Pt_ARG_IMAGETREE_COLUMNS                              = ( 49 * 1000 + 2 );
//public static final int Pt_ARG_IN_EXDATA                                      = 0x00100000;
//public static final int Pt_ARG_IN_WDATA                                       = 0x00200000;
	public static final int Pt_ARG_INCREMENT                                      = ( 29 * 1000 + 1 );
//public static final int Pt_ARG_INDICATOR_COLOR                                = ( 9 * 1000 + 0 );
//public static final int Pt_ARG_INDICATOR_DEPTH                                = ( 9 * 1000 + 6 );
//public static final int Pt_ARG_INDICATOR_HEIGHT                               = ( 9 * 1000 + 8 );
	public static final int Pt_ARG_INDICATOR_TYPE                                 = ( 9 * 1000 + 2 );
//public static final int Pt_ARG_INDICATOR_WIDTH                                = ( 9 * 1000 + 7 );
	public static final int Pt_ARG_ITEMS                                          = ( 23 * 1000 +  1 );
//public static final int Pt_ARG_LABEL_BALLOON                                  = ( 3 * 1000 + 17 );
//public static final int Pt_ARG_LABEL_DATA                                     = ( 3 * 1000 + 1 );
//public static final int Pt_ARG_LABEL_FLAGS                                    = ( 3 * 1000 + 2 );
	public static final int Pt_ARG_LABEL_TYPE                                     = ( 3 * 1000 + 3 );
//public static final int Pt_ARG_LINE_CAP                                       = ( 25 * 1000 + 4 );
//public static final int Pt_ARG_LINE_JOIN                                      = ( 25 * 1000 + 3 );
	public static final int Pt_ARG_LINE_SPACING                                   = ( 3 * 1000 + 21 );
//public static final int Pt_ARG_LINE_WIDTH                                     = ( 25 * 1000 + 2 );
//public static final int Pt_ARG_LIST_BALLOON                                   = ( 23 * 1000 + 31 );
//public static final int Pt_ARG_LIST_COLUMN_ATTR                               = ( 23 * 1000 + 28 );
//public static final int Pt_ARG_LIST_COLUMN_POS                                = ( 23 * 1000 + 27 );
	public static final int Pt_ARG_LIST_FLAGS                                     = ( 23 * 1000 +  2 );
	public static final int Pt_ARG_LIST_FONT                                      = ( 23 * 1000 +  3 );
	public static final int Pt_ARG_LIST_ITEM_COUNT                                = ( 23 * 1000 + 14 );
//public static final int Pt_ARG_LIST_SB_RES                                    = ( 23 * 1000 + 25 );
//public static final int Pt_ARG_LIST_SCROLL_RATE                               = ( 23 * 1000 + 26 );
	public static final int Pt_ARG_LIST_SEL_COUNT                                 = ( 23 * 1000 + 15 );
//public static final int Pt_ARG_LIST_SPACING                                   = ( 23 * 1000 +  4 );
	public static final int Pt_ARG_LIST_TOTAL_HEIGHT                              = ( 23 * 1000 + 16 );
	public static final int Pt_ARG_MARGIN_BOTTOM                                  = ( 3 * 1000 + 4 );
	public static final int Pt_ARG_MARGIN_HEIGHT                                  = ( 2 * 1000 + 4 );
	public static final int Pt_ARG_MARGIN_LEFT                                    = ( 3 * 1000 + 5 );
	public static final int Pt_ARG_MARGIN_RIGHT                                   = ( 3 * 1000 + 6 );
	public static final int Pt_ARG_MARGIN_TOP                                     = ( 3 * 1000 + 7 );
	public static final int Pt_ARG_MARGIN_WIDTH                                   = ( 2 * 1000 + 5 );
//public static final int Pt_ARG_MAX_HEIGHT                                     = ( 18 * 1000 + 4 );
	public static final int Pt_ARG_MAX_LENGTH                                     = ( 4 * 1000 + 5 );
//public static final int Pt_ARG_MAX_WIDTH                                      = ( 18 * 1000 + 5 );
	public static final int Pt_ARG_MENU_FLAGS                                     = ( 19 * 1000 + 0 );
//public static final int Pt_ARG_MENU_SPACING                                   = ( 19 * 1000 + 1 );
//public static final int Pt_ARG_MENU_TEXT_FONT                                 = ( 19 * 1000 + 2 );
//public static final int Pt_ARG_MENU_TITLE                                     = ( 19 * 1000 + 3 );
//public static final int Pt_ARG_MENU_TITLE_FONT                                = ( 19 * 1000 + 4 );
//public static final int Pt_ARG_MENUBAR_FLAGS                                  = ( 37 * 1000 + 0 );
//public static final int Pt_ARG_MIN_HEIGHT                                     = ( 18 * 1000 + 6 );
//public static final int Pt_ARG_MIN_SLIDER_SIZE                                = ( 29 * 1000 + 11 );
//public static final int Pt_ARG_MIN_WIDTH                                      = ( 18 * 1000 + 7 );
//public static final int Pt_ARG_MLTITXT_FLAGS                                  = ( 5 * 1000 + 2 );
//public static final int Pt_ARG_MODE_ALLOC                                     = 0x000A0000;
//public static final int Pt_ARG_MODE_ARRAY                                     = 0x000C0000;
//public static final int Pt_ARG_MODE_BOOLEAN                                   = 0x00080000;
//public static final int Pt_ARG_MODE_CHAR                                      = 0x00010000;
//public static final int Pt_ARG_MODE_CHAR_FLAGS                                = 0x00040000;
//public static final int Pt_ARG_MODE_LONG                                      = 0x00030000;
//public static final int Pt_ARG_MODE_INT                                       = Pt_ARG_MODE_LONG;
//public static final int Pt_ARG_MODE_LINKED                                    = 0x000D0000;
//public static final int Pt_ARG_MODE_LONG_FLAGS                                = 0x00060000;
//public static final int Pt_ARG_MODE_MASK                                      = 0x000F0000;
//public static final int Pt_ARG_MODE_PTR                                       = 0x00070000;
//public static final int Pt_ARG_MODE_SHORT                                     = 0x00020000;
//public static final int Pt_ARG_MODE_SHORT_FLAGS                               = 0x00050000;
//public static final int Pt_ARG_MODE_STRALLOC                                  = 0x000B0000;
//public static final int Pt_ARG_MODE_STRING                                    = 0x000B0000;
//public static final int Pt_ARG_MODE_STRUCT                                    = 0x00090000;
//public static final int Pt_ARG_MODE_VARIABLE                                  = 0x00090000;
//public static final int Pt_ARG_MODIFY_ITEMS                                   = ( 23 * 1000 + 29 );
//public static final int Pt_ARG_MSG_BUTTON1                                    = ( 32 * 1000 + 4 );
//public static final int Pt_ARG_MSG_BUTTON2                                    = ( 32 * 1000 + 5 );
//public static final int Pt_ARG_MSG_BUTTON3                                    = ( 32 * 1000 + 6 );
//public static final int Pt_ARG_MSG_DEFAULT                                    = ( 32 * 1000 + 7 );
//public static final int Pt_ARG_MSG_ESCAPE                                     = ( 32 * 1000 + 2 );
//public static final int Pt_ARG_MSG_FLAGS                                      = ( 32 * 1000 + 11 );
//public static final int Pt_ARG_MSG_FONT                                       = ( 32 * 1000 + 3 );
//public static final int Pt_ARG_MSG_TEXT                                       = ( 32 * 1000 + 1 );
//public static final int Pt_ARG_MSG_TITLE                                      = ( 32 * 1000 + 0 );
//public static final int Pt_ARG_MULTITEXT_BOTTOM_LINE                          = ( 5 * 1000 + 8 );
//public static final int Pt_ARG_MULTITEXT_FLAGS                                = ( 5 * 1000 + 15 );
	public static final int Pt_ARG_MULTITEXT_LINE_SPACING                         = ( 5 * 1000 + 3 );
	public static final int Pt_ARG_MULTITEXT_NUM_LINES                            = ( 5 * 1000 + 6 );
//public static final int Pt_ARG_MULTITEXT_NUM_LINES_VISIBLE                    = ( 5 * 1000 + 5 );
//public static final int Pt_ARG_MULTITEXT_QUERY_CHARACTER                      = ( 5 * 1000 + 11 );
	public static final int Pt_ARG_MULTITEXT_QUERY_LINE                           = ( 5 * 1000 + 10 );
//public static final int Pt_ARG_MULTITEXT_RANGE_ATTRIBUTES                     = ( 5 * 1000 + 0 );
//public static final int Pt_ARG_MULTITEXT_ROWS                                 = ( 5 * 1000 + 12 );
//public static final int Pt_ARG_MULTITEXT_SEGMENTS                             = ( 5 * 1000 + 4 );
	public static final int Pt_ARG_MULTITEXT_TABS                                 = ( 5 * 1000 + 13 );
	public static final int Pt_ARG_MULTITEXT_TOP_LINE                             = ( 5 * 1000 + 7 );
	public static final int Pt_ARG_MULTITEXT_WRAP_FLAGS                           = ( 5 * 1000 + 1 );
//public static final int Pt_ARG_MULTITEXT_X_SCROLL_POS                         = ( 5 * 1000 + 9 );
//public static final int Pt_ARG_MULTITEXT_Y_SCROLL_POS                         = ( 5 * 1000 + 7 );
//public static final int Pt_ARG_NUM_FRAMES                                     = ( 101 * 1000 + 1 );
//public static final int Pt_ARG_NUMERIC_FLAGS                                  = ( 53 * 1000 + 1 );
//public static final int Pt_ARG_NUMERIC_INCREMENT                              = ( 53 * 1000 + 3 );
//public static final int Pt_ARG_NUMERIC_MAX                                    = ( 53 * 1000 + 6 );
//public static final int Pt_ARG_NUMERIC_MIN                                    = ( 53 * 1000 + 5 );
//public static final int Pt_ARG_NUMERIC_PRECISION                              = ( 53 * 1000 + 16 );
//public static final int Pt_ARG_NUMERIC_PREFIX                                 = ( 53 * 1000 + 7 );
//public static final int Pt_ARG_NUMERIC_SPACING                                = ( 53 * 1000 + 17 );
//public static final int Pt_ARG_NUMERIC_SUFFIX                                 = ( 53 * 1000 + 8 );
//public static final int Pt_ARG_NUMERIC_TEXT_BORDER                            = ( 53 * 1000 + 9 );
//public static final int Pt_ARG_NUMERIC_TEXT_BOT_BORDER_COLOR                  = ( 53 * 1000 + 14 );
//public static final int Pt_ARG_NUMERIC_TEXT_COLOR                             = ( 53 * 1000 + 11 );
//public static final int Pt_ARG_NUMERIC_TEXT_FILL_COLOR                        = ( 53 * 1000 + 12 );
//public static final int Pt_ARG_NUMERIC_TEXT_FLAGS                             = ( 53 * 1000 + 19 );
//public static final int Pt_ARG_NUMERIC_TEXT_FONT                              = ( 53 * 1000 + 10 );
//public static final int Pt_ARG_NUMERIC_TEXT_TOP_BORDER_COLOR                  = ( 53 * 1000 + 13 );
//public static final int Pt_ARG_NUMERIC_UPDOWN_BORDER_WIDTH                    = ( 53 * 1000 + 18 );
//public static final int Pt_ARG_NUMERIC_UPDOWN_WIDTH                           = ( 53 * 1000 + 2 );
//public static final int Pt_ARG_NUMERIC_VALUE                                  = ( 53 * 1000 + 4 );
//public static final int Pt_ARG_OFFSET                                         = ( 7 * 1000 + 3 );
//public static final int Pt_ARG_OFFSET_MASK                                    = 0x0000FFFF;
//public static final int Pt_ARG_ONOFF_STATE                                    = ( 8 * 1000 + 0 );
//public static final int Pt_ARG_ORIGIN                                         = ( 25 * 1000 + 5 );
	public static final int Pt_ARG_PAGE_INCREMENT                                 = ( 29 * 1000 + 5 );
//public static final int Pt_ARG_PANE_FLAGS                                     = ( 12 * 1000 + 0 );
//public static final int Pt_ARG_PANE_RECT                                      = ( 12 * 1000 + 1 );
//public static final int Pt_ARG_POINTS                                         = ( 25 * 1000 + 6 );
//public static final int Pt_ARG_POLYGON_FLAGS                                  = ( 27 * 1000 + 1 );
	public static final int Pt_ARG_POS                                            = ( 1 * 1000 + 7 );
//public static final int Pt_ARG_PRINT_CONTEXT                                  = (46 * 1000 + 0);
//public static final int Pt_ARG_PRINT_FLAGS                                    = (46 * 1000 + 1);
//public static final int Pt_ARG_PS_ALL_PAGES_LABEL                             = (46 * 1000 + 12);
//public static final int Pt_ARG_PS_COLLATE_METHOD_LABEL                        = (46 * 1000 + 6);
//public static final int Pt_ARG_PS_COPIES_LABEL                                = (46 * 1000 + 10);
//public static final int Pt_ARG_PS_FILENAME_LABEL                              = (46 * 1000 + 16);
//public static final int Pt_ARG_PS_LOCATION_LABEL                              = (46 * 1000 + 7);
//public static final int Pt_ARG_PS_NUM_COPIES_LABEL                            = (46 * 1000 + 5);
//public static final int Pt_ARG_PS_PAGES_LABEL                                 = (46 * 1000 + 13);
//public static final int Pt_ARG_PS_PRINT_RANGE_LABEL                           = (46 * 1000 + 9);
//public static final int Pt_ARG_PS_PRINTER_LABEL                               = (46 * 1000 + 8);
//public static final int Pt_ARG_PS_PROPERTIES_LABEL                            = (46 * 1000 + 11);
//public static final int Pt_ARG_PS_SEL_TITLE                                   = (46 * 1000 + 4);
//public static final int Pt_ARG_PS_SELECTION_LABEL                             = (46 * 1000 + 15);
//public static final int Pt_ARG_PS_TOFILE_LABEL                                = (46 * 1000 + 14);
//public static final int Pt_ARG_RAW_CALLBACKS                                  = ( 1 * 1000 + 11 );
//public static final int Pt_ARG_RAW_CONNECT_F                                  = ( 24 * 1000 + 1 );
//public static final int Pt_ARG_RAW_DRAW_F                                     = ( 24 * 1000 + 0 );
//public static final int Pt_ARG_RAW_EXTENT_F                                   = ( 24 * 1000 + 2 );
//public static final int Pt_ARG_RAW_INIT_F                                     = ( 24 * 1000 + 3 );
//public static final int Pt_ARG_RECT_ROUNDNESS                                 = ( 28 * 1000 + 0 );
//public static final int Pt_ARG_REGION_CURSOR                                  = ( 1 * 1000 + 2 );
//public static final int Pt_ARG_REGION_CURSOR_COLOR                            = ( 1 * 1000 + 3 );
//public static final int Pt_ARG_REGION_DATA                                    = ( 15 * 1000 + 9 );
//public static final int Pt_ARG_REGION_FIELDS                                  = ( 15 * 1000 + 2 );
	public static final int Pt_ARG_REGION_FLAGS                                   = ( 15 * 1000 + 3 );
//public static final int Pt_ARG_REGION_HANDLE                                  = ( 15 * 1000 + 4 );
//public static final int Pt_ARG_REGION_INFRONT                                 = ( 15 * 1000 + 10 );
//public static final int Pt_ARG_REGION_INPUT_GROUP                             = ( 15 * 1000 + 11 );
	public static final int Pt_ARG_REGION_OPAQUE                                  = ( 15 * 1000 + 5 );
//public static final int Pt_ARG_REGION_OWNER                                   = ( 15 * 1000 + 6 );
//public static final int Pt_ARG_REGION_PARENT                                  = ( 15 * 1000 + 7 );
	public static final int Pt_ARG_REGION_SENSE                                   = ( 15 * 1000 + 8 );
	public static final int Pt_ARG_RESIZE_FLAGS                                   = ( 1 * 1000 + 8 );
//public static final int Pt_ARG_SCROLL_AREA_FLAGS                              = ( 13 * 1000 + 12 );
//public static final int Pt_ARG_SCROLL_AREA_INCREMENT_X                        = ( 13 * 1000 + 0 );
//public static final int Pt_ARG_SCROLL_AREA_INCREMENT_Y                        = ( 13 * 1000 + 1 );
	public static final int Pt_ARG_SCROLL_AREA_MAX_X                              = ( 13 * 1000 + 2 );
	public static final int Pt_ARG_SCROLL_AREA_MAX_Y                              = ( 13 * 1000 + 3 );
//public static final int Pt_ARG_SCROLL_AREA_POS_X                              = ( 13 * 1000 + 5 );
//public static final int Pt_ARG_SCROLL_AREA_POS_Y                              = ( 13 * 1000 + 4 );
//public static final int Pt_ARG_SCROLLBAR                                      = ( 23 * 1000 + 11 );
//public static final int Pt_ARG_SCROLLBAR_FLAGS                                = ( 29 * 1000 + 9 );
	public static final int Pt_ARG_SCROLLBAR_WIDTH                                = ( 23 * 1000 +  5 );
	public static final int Pt_ARG_SCROLLBAR_X_DISPLAY                            = ( 13 * 1000 + 6 );
//public static final int Pt_ARG_SCROLLBAR_X_HEIGHT                             = ( 13 * 1000 + 7 );
	public static final int Pt_ARG_SCROLLBAR_Y_DISPLAY                            = ( 13 * 1000 + 8 );
//public static final int Pt_ARG_SCROLLBAR_Y_WIDTH                              = ( 13 * 1000 + 9 );
//public static final int Pt_ARG_SEL_INDEXES                                    = ( 23 * 1000 +  6 );
//public static final int Pt_ARG_SEL_MODE                                       = ( 23 * 1000 +  7 );
//public static final int Pt_ARG_SELECT_SHIFT                                   = ( 3 * 1000 + 9 );
	public static final int Pt_ARG_SELECTION_FILL_COLOR                           = ( 23 * 1000 + 12 );
	public static final int Pt_ARG_SELECTION_INDEXES                              = ( 23 * 1000 +  6 );
	public static final int Pt_ARG_SELECTION_MODE                                 = ( 23 * 1000 +  7 );
	public static final int Pt_ARG_SELECTION_RANGE                                = ( 4 * 1000 + 12 );
	public static final int Pt_ARG_SELECTION_TEXT_COLOR                           = ( 23 * 1000 + 13 );
	public static final int Pt_ARG_SEP_FLAGS                                      = ( 30 * 1000 + 0 );
//public static final int Pt_ARG_SEP_ORIENTATION                                = ( 30 * 1000 + 1 );
	public static final int Pt_ARG_SEP_TYPE                                       = ( 30 * 1000 + 2 );
//public static final int Pt_ARG_SERVER_CONNECTION                              = ( 98 * 1000 +  6 );
//public static final int Pt_ARG_SERVER_NAME                                    = ( 98 * 1000 +  7 );
//public static final int Pt_ARG_SERVER_SEND                                    = ( 98 * 1000 +  2 );
//public static final int Pt_ARG_SET_BITMAP_COLORS                              = ( 20 * 1000 + 5 );
//public static final int Pt_ARG_SET_BITMAP_DATA                                = ( 20 * 1000 + 6 );
//public static final int Pt_ARG_SET_COLOR                                      = ( 9 * 1000 + 3 );
//public static final int Pt_ARG_SET_FILL                                       = ( 9 * 1000 + 4 );
//public static final int Pt_ARG_SHOW_ARROWS                                    = ( 29 * 1000 + 6 );
//public static final int Pt_ARG_SIZE_MASK                                      = 0xFFC00000;
//public static final int Pt_ARG_SIZE_SHIFT                                     = 22;
//public static final int Pt_ARG_SLIDER_FLAGS                                   = ( 22 * 1000 + 0 );
//public static final int Pt_ARG_SLIDER_HANDLE_HEIGHT                           = ( 22 * 1000 + 8 );
//public static final int Pt_ARG_SLIDER_HANDLE_WIDTH                            = ( 22 * 1000 + 7 );
//public static final int Pt_ARG_SLIDER_IMAGE                                   = ( 22 * 1000 + 9 );
//public static final int Pt_ARG_SLIDER_INCREMENT                               = ( 22 * 1000 + 1 );
//public static final int Pt_ARG_SLIDER_LABEL_BR                                = ( 22 * 1000 + 3 );
//public static final int Pt_ARG_SLIDER_LABEL_BR_COL                            = ( 22 * 1000 + 5 );
//public static final int Pt_ARG_SLIDER_LABEL_TL                                = ( 22 * 1000 + 2 );
//public static final int Pt_ARG_SLIDER_LABEL_TL_COL                            = ( 22 * 1000 + 4 );
//public static final int Pt_ARG_SLIDER_MULTIPLE                                = ( 22 * 1000 + 6 );
//public static final int Pt_ARG_SLIDER_ORIENTATION                             = ( 22 * 1000 + 19 );
	public static final int Pt_ARG_SLIDER_SIZE                                    = ( 29 * 1000 + 7 );
//public static final int Pt_ARG_SLIDER_TICK_MAJOR_COL                          = ( 22 * 1000 + 10 );
//public static final int Pt_ARG_SLIDER_TICK_MAJOR_DIV                          = ( 22 * 1000 + 13 );
//public static final int Pt_ARG_SLIDER_TICK_MAJOR_LEN                          = ( 22 * 1000 + 14 );
//public static final int Pt_ARG_SLIDER_TICK_MINOR_COL                          = ( 22 * 1000 + 11 );
//public static final int Pt_ARG_SLIDER_TICK_MINOR_DIV                          = ( 22 * 1000 + 12 );
//public static final int Pt_ARG_SLIDER_TICK_MINOR_LEN                          = ( 22 * 1000 + 15 );
//public static final int Pt_ARG_SLIDER_TROUGH_COL                              = ( 22 * 1000 + 18 );
//public static final int Pt_ARG_SLIDER_TROUGH_SIZE                             = ( 22 * 1000 + 16 );
//public static final int Pt_ARG_SPACING                                        = ( 9 * 1000 + 5 );
//public static final int Pt_ARG_TAB_FLAGS                                      = ( 58 * 1000 + 0 );
//public static final int Pt_ARG_TEMPLATE_1                                     = ( 5001 * 1000 + 0 );
//public static final int Pt_ARG_TEMPLATE_2                                     = ( 5001 * 1000 + 1 );
//public static final int Pt_ARG_TEXT_CURSOR_WIDTH                              = ( 4 * 1000 + 18 );
	public static final int Pt_ARG_TEXT_FLAGS                                     = ( 4 * 1000 + 8 );
	public static final int Pt_ARG_TEXT_FONT                                      = ( 3 * 1000 + 10 );
//public static final int Pt_ARG_TEXT_HIGHLIGHT_BACKGROUND_COLOR                = ( 4 * 1000 + 17 );
//public static final int Pt_ARG_TEXT_HIGHLIGHT_TEXT_COLOR                      = ( 4 * 1000 + 16 );
	public static final int Pt_ARG_TEXT_STRING                                    = ( 3 * 1000 + 11 );
//public static final int Pt_ARG_TEXT_SUBSTRING                                 = ( 4 * 1000 + 13 );
	public static final int Pt_ARG_TIMER_INITIAL                                  = ( 41 * 1000 + 0 );
//public static final int Pt_ARG_TIMER_REPEAT                                   = ( 41 * 1000 + 1 );
//public static final int Pt_ARG_TOP_BORDER_COLOR                               = ( 2 * 1000 + 6 );
	public static final int Pt_ARG_TOP_ITEM_POS                                   = ( 23 * 1000 +  8 );
//public static final int Pt_ARG_TRANS_PATTERN                                  = ( 2 * 1000 + 13 );
//public static final int Pt_ARG_TREE_BALLOON                                   = ( 23 * 1000 + 30 );
//public static final int Pt_ARG_TREE_FLAGS                                     = ( 23 * 1000 + 18 );
	public static final int Pt_ARG_TREE_IMAGES                                    = ( 23 * 1000 + 19 );
//public static final int Pt_ARG_TREE_IMGMASK                                   = ( 23 * 1000 + 20 );
//public static final int Pt_ARG_UNDERLINE1                                     = ( 3 * 1000 + 12 );
//public static final int Pt_ARG_UNDERLINE2                                     = ( 3 * 1000 + 13 );
//public static final int Pt_ARG_UNDERLINE_TYPE                                 = ( 3 * 1000 + 14 );
//public static final int Pt_ARG_UPDOWN_ARM_DATA_BOT                            = ( 52 * 1000 + 8 );
//public static final int Pt_ARG_UPDOWN_ARM_DATA_BOTTOM                         = ( 52 * 1000 + 8 );
//public static final int Pt_ARG_UPDOWN_ARM_DATA_LEF                            = ( 52 * 1000 + 9 );
//public static final int Pt_ARG_UPDOWN_ARM_DATA_LEFT                           = ( 52 * 1000 + 9 );
//public static final int Pt_ARG_UPDOWN_ARM_DATA_RIGHT                          = ( 52 * 1000 + 10 );
//public static final int Pt_ARG_UPDOWN_ARM_DATA_RIT                            = ( 52 * 1000 + 10 );
//public static final int Pt_ARG_UPDOWN_ARM_DATA_TOP                            = ( 52 * 1000 + 7 );
//public static final int Pt_ARG_UPDOWN_BOT_BDR_COLOR                           = ( 52 * 1000 + 12 );
//public static final int Pt_ARG_UPDOWN_BOTTOM_BORDER_COLOR                     = ( 52 * 1000 + 12 );
//public static final int Pt_ARG_UPDOWN_DATA_BOT                                = ( 52 * 1000 + 4 );
//public static final int Pt_ARG_UPDOWN_DATA_BOTTOM                             = ( 52 * 1000 + 4 );
//public static final int Pt_ARG_UPDOWN_DATA_LEF                                = ( 52 * 1000 + 5 );
//public static final int Pt_ARG_UPDOWN_DATA_LEFT                               = ( 52 * 1000 + 5 );
//public static final int Pt_ARG_UPDOWN_DATA_RIGHT                              = ( 52 * 1000 + 6 );
//public static final int Pt_ARG_UPDOWN_DATA_RIT                                = ( 52 * 1000 + 6 );
//public static final int Pt_ARG_UPDOWN_DATA_TOP                                = ( 52 * 1000 + 3 );
//public static final int Pt_ARG_UPDOWN_FILL_COLOR                              = ( 52 * 1000 + 16 );
//public static final int Pt_ARG_UPDOWN_FLAGS                                   = ( 52 * 1000 + 15 );
//public static final int Pt_ARG_UPDOWN_HIGHLGHT_ROUND                          = ( 52 * 1000 + 14 );
//public static final int Pt_ARG_UPDOWN_HIGHLIGHT_ROUND                         = ( 52 * 1000 + 14 );
//public static final int Pt_ARG_UPDOWN_MARGIN_HEIGHT                           = ( 52 * 1000 + 17 );
//public static final int Pt_ARG_UPDOWN_MARGIN_WIDTH                            = ( 52 * 1000 + 18 );
//public static final int Pt_ARG_UPDOWN_ORIENTATION                             = ( 52 * 1000 + 1 );
//public static final int Pt_ARG_UPDOWN_SPACING                                 = ( 52 * 1000 + 2 );
//public static final int Pt_ARG_UPDOWN_TOP_BDR_COLOR                           = ( 52 * 1000 + 13 );
//public static final int Pt_ARG_UPDOWN_TOP_BORDER_COLOR                        = ( 52 * 1000 + 13 );
	public static final int Pt_ARG_USER_DATA                                      = ( 1 * 1000 + 14 );
	public static final int Pt_ARG_VERTICAL_ALIGNMENT                             = ( 3 * 1000 + 15 );
	public static final int Pt_ARG_VISIBLE_COUNT                                  = ( 23 * 1000 +  9 );
//public static final int Pt_ARG_WIN_PARENT                                     = ( 18 * 1000 + 8 );
//public static final int Pt_ARG_WINDOW_ACTIVE_COLOR                            = ( 18 * 1000 + 18 );
//public static final int Pt_ARG_WINDOW_CURSOR_OVERRIDE                         = ( 18 * 1000 + 9 );
//public static final int Pt_ARG_WINDOW_FORCE_FRONT                             = ( 18 * 1000 + 10 );
//public static final int Pt_ARG_WINDOW_FRONT_WINDOW                            = ( 18 * 1000 + 22 );
//public static final int Pt_ARG_WINDOW_HELP_ROOT                               = ( 18 * 1000 + 20 );
//public static final int Pt_ARG_WINDOW_INACTIVE_COLOR                          = ( 18 * 1000 + 19 );
	public static final int Pt_ARG_WINDOW_MANAGED_FLAGS                           = ( 18 * 1000 + 11 );
	public static final int Pt_ARG_WINDOW_NOTIFY_FLAGS                            = ( 18 * 1000 + 12 );
	public static final int Pt_ARG_WINDOW_RENDER_FLAGS                            = ( 18 * 1000 + 13 );
	public static final int Pt_ARG_WINDOW_STATE                                   = ( 18 * 1000 + 14 );
	public static final int Pt_ARG_WINDOW_TITLE                                   = ( 18 * 1000 + 15 );
//public static final int Pt_ARG_WINDOW_TITLE_COLOR                             = ( 18 * 1000 + 16 );
	public static final int Pt_AS_REQUIRED                                        = 0x02;
	public static final int Pt_AUTO_EXTENT                                        = 0x00000002;
	public static final int Pt_AUTOHIGHLIGHT                                      = 0x00000004;
//public static final int Pt_BACKFILL_TEXT                                      = 0x10;
//public static final int Pt_BALLOON_AS_REQUIRED                                = 0x08;
	public static final int Pt_BALLOON_BOTTOM                                     = 3;
//public static final int Pt_BALLOON_INPLACE                                    = 4;
//public static final int Pt_BALLOON_LEFT                                       = 1;
//public static final int Pt_BALLOON_PROPAGATE                                  = 0x00000040;
//public static final int Pt_BALLOON_REGISTERED                                 = 0x80;
	public static final int Pt_BALLOON_RIGHT                                      = 0;
//public static final int Pt_BALLOON_TOP                                        = 2;
//public static final int Pt_BALLOONS_ACTIVE                                    = 0x02000000;
//public static final int Pt_BALLOONS_LOCKED                                    = 0x80000000;
//public static final int Pt_BALLOONS_ON                                        = 0x00001000;
//public static final int Pt_BASIC_RO_FLAGS                                     = 0xffffffff;
//public static final int Pt_BITMAP                                             = 0x02;
//public static final int Pt_BITMAP_BALLOON_BOTTOM                              = 3;
//public static final int Pt_BITMAP_BALLOON_INPLACE                             = 4;
//public static final int Pt_BITMAP_BALLOON_LEFT                                = 1;
//public static final int Pt_BITMAP_BALLOON_RIGHT                               = 0;
//public static final int Pt_BITMAP_BALLOON_TOP                                 = 2;
//public static final int Pt_BITMAP_SHOW_BALLOON                                = 0x04;
//public static final int Pt_BKGD_ALT                                           = 2;
//public static final int Pt_BKGD_BRIGHTNESS                                    = 3;
//public static final int Pt_BKGD_CENTER                                        = 3;
//public static final int Pt_BKGD_CENTER_GRID                                   = 4;
//public static final int Pt_BKGD_GRID                                          = 1;
//public static final int Pt_BKGD_HORIZONTAL                                    = 1;
//public static final int Pt_BKGD_HUE                                           = 1;
//public static final int Pt_BKGD_IMAGE                                         = 5;
//public static final int Pt_BKGD_NONE                                          = 0;
//public static final int Pt_BKGD_PIXMAP                                        = 4;
//public static final int Pt_BKGD_SATURATION                                    = 2;
//public static final int Pt_BKGD_VERTICAL                                      = 2;
//public static final int Pt_BLIT                                               = 0xFFFF;
//public static final int Pt_BLIT_FORCE                                         = 0xFFFE;
//public static final int Pt_BLOCK_CUA_FOCUS                                    = 0x00000001;
	public static final int Pt_BLOCKED                                            = 0x00020000;
//public static final int Pt_BOTTOM                                             = 1;
	public static final int Pt_BOTTOM_ANCHORED_BOTTOM                           = 0x00000080;
	public static final int Pt_BOTTOM_ANCHORED_RELATIVE                         = 0x00000008;
	public static final int Pt_BOTTOM_ANCHORED_TOP                              = 0x00000800;
	public static final int Pt_BOTTOM_IS_ANCHORED                               = Pt_BOTTOM_ANCHORED_BOTTOM | Pt_BOTTOM_ANCHORED_RELATIVE | Pt_BOTTOM_ANCHORED_TOP;
//public static final int Pt_BROWSE_MODE                                        = 3;
//public static final int Pt_CALENDAR_DATE_SELECTED                             = 1;
//public static final int Pt_CALENDAR_ID                                        = 56;
//public static final int Pt_CALENDAR_MONTH_BTNS                                = 2;
//public static final int Pt_CALENDAR_MONTH_SELECTED                            = 3;
//public static final int Pt_CALENDAR_SHOW_GRID                                 = 16;
//public static final int Pt_CALENDAR_SHOW_NEXT                                 = 8;
//public static final int Pt_CALENDAR_SHOW_PREV                                 = 4;
//public static final int Pt_CALENDAR_WDAY_SELECTED                             = 2;
//public static final int Pt_CALENDAR_YEAR_BTNS                                 = 1;
//public static final int Pt_CALENDAR_YEAR_SELECTED                             = 4;
	public static final int Pt_CALLBACKS_ACTIVE                                   = 0x04000000;
//public static final int Pt_CANVAS_INVALID                                     = 0x00004000;
	public static final int Pt_CB_ACTIVATE                                        = ( 2 * 1000 + 9 );
	public static final int Pt_CB_ARM                                             = ( 2 * 1000 + 7 );
//public static final int Pt_CB_BALLOONS                                        = ( 10 * 1000 + 4 );
//public static final int Pt_CB_BLOCKED                                         = ( 1 * 1000 + 16 );
//public static final int Pt_CB_CALENDAR_SELECT                                 = ( 56 * 1000 + 16 );
//public static final int Pt_CB_CBOX_ACTIVATE                                   = ( 31 * 1000 + 14 );
//public static final int Pt_CB_CBOX_CLOSE                                      = ( 31 * 1000 + 20 );
//public static final int Pt_CB_CLIENT_CONNECTED                                = ( 99 * 1000 +  6 );
//public static final int Pt_CB_CLIENT_EVENT                                    = ( 99 * 1000 +  3 );
//public static final int Pt_CB_CLIENT_NOT_FOUND                                = ( 99 * 1000 +  8 );
//public static final int Pt_CB_CLOCK_TIME_CHANGED                              = (57 * 1000 +18);
//public static final int Pt_CB_DESTROYED                                       = ( 1 * 1000 + 9 );
//public static final int Pt_CB_DISARM                                          = ( 2 * 1000 + 8 );
//public static final int Pt_CB_DIVIDER_DRAG                                    = ( 44 * 1000 +  3 );
//public static final int Pt_CB_DIVIDER_SETRESOURCES                            = 9;
//public static final int Pt_CB_FONT_MODIFY                                     = (38 * 1000 + 4);
//public static final int Pt_CB_FS_BKGD_HANDLER                                 = ( 47 * 1000 + 8 );
//public static final int Pt_CB_FS_SELECTION                                    = ( 47 * 1000 + 7 );
//public static final int Pt_CB_FS_STATE                                        = ( 47 * 1000 + 6 );
//public static final int Pt_CB_GEN_TREE_INPUT                                  = ( 23 * 1000 + 23 );
	public static final int Pt_CB_GOT_FOCUS                                       = ( 2 * 1000 + 10 );
//public static final int Pt_CB_HOTKEY                                          = ( 1 * 1000 + 10);
//public static final int Pt_CB_HTML_ERROR                                      = ( 45 * 1000 + 30 );
//public static final int Pt_CB_HTML_FILE_POST                                  = ( 45 * 1000 + 16 );
//public static final int Pt_CB_HTML_FILE_PRE                                   = ( 45 * 1000 + 15 );
//public static final int Pt_CB_HTML_IMAGE                                      = ( 45 * 1000 + 17 );
//public static final int Pt_CB_IMAGEAREA_DRAG                                  = ( 103 * 1000 + 15 );
//public static final int Pt_CB_IMAGEAREA_MOVEMENT                              = ( 103 * 1000 + 10 );
//public static final int Pt_CB_IMAGEAREA_SCROLLED                              = ( 103 * 1000 + 9 );
//public static final int Pt_CB_IMAGEAREA_SELECTION                             = ( 103 * 1000 + 11 );
//public static final int Pt_CB_IMAGETREE_COLUMN_SEL                            = ( 49 * 1000 + 3 );
//public static final int Pt_CB_IS_DESTROYED                                    = ( 1 * 1000 + 19 );
//public static final int Pt_CB_LIST_INPUT                                      = ( 23 * 1000 + 24 );
	public static final int Pt_CB_LOST_FOCUS                                      = ( 2 * 1000 + 11 );
	public static final int Pt_CB_MENU                                            = ( 2 * 1000 + 16 );
//public static final int Pt_CB_MODIFY_NOTIFY                                   = ( 4 * 1000 + 10);
	public static final int Pt_CB_MODIFY_VERIFY                                   = ( 4 * 1000 + 9 );
//public static final int Pt_CB_MOTION_NOTIFY                                   = ( 4 * 1000 + 14);
//public static final int Pt_CB_MOTION_VERIFY                                   = ( 4 * 1000 + 11);
//public static final int Pt_CB_MSG_BUTTON1                                     = ( 32 * 1000 + 8 );
//public static final int Pt_CB_MSG_BUTTON2                                     = ( 32 * 1000 + 9 );
//public static final int Pt_CB_MSG_BUTTON3                                     = ( 32 * 1000 +10 );
//public static final int Pt_CB_MULTITEXT_SCROLLUPDATE                          = ( 5 * 1000 + 14 );
//public static final int Pt_CB_NUMERIC_CHANGED                                 = ( 53 * 1000 + 15 );
//public static final int Pt_CB_ONOFF_NEW_VALUE                                 = ( 8 * 1000 + 1 );
//public static final int Pt_CB_PRINT_PROPS                                     = (46 * 1000 + 2);
//public static final int Pt_CB_PRINT_TOFILE                                    = (46 * 1000 + 3);
//public static final int Pt_CB_RAW                                             = ( 1 * 1000 + 11 );
//public static final int Pt_CB_RAW_EVENT                                       = ( 1 * 1000 + 11 );
	public static final int Pt_CB_REALIZED                                        = ( 1 * 1000 + 12 );
//public static final int Pt_CB_REPEAT                                          = ( 2 * 1000 + 12 );
//public static final int Pt_CB_RESCALE                                         = ( 25 * 1000 + 7 );
	public static final int Pt_CB_RESIZE                                          = ( 10 * 1000 + 3 );
	public static final int Pt_CB_SCROLL_MOVE                                     = ( 29 * 1000 + 10 );
//public static final int Pt_CB_SCROLLED_X                                      = ( 13 * 1000 + 10 );
//public static final int Pt_CB_SCROLLED_Y                                      = ( 13 * 1000 + 11 );
	public static final int Pt_CB_SELECTION                                       = ( 23 * 1000 + 10 );
//public static final int Pt_CB_SERVER_CONNECTED                                = ( 98 * 1000 +  8 );
//public static final int Pt_CB_SERVER_RECEIVE                                  = ( 98 * 1000 +  3 );
//public static final int Pt_CB_SERVER_TRANSPORT                                = ( 98 * 1000 +  4 );
	public static final int Pt_CB_SLIDER_MOVE                                     = ( 22 * 1000 + 17 );
//public static final int Pt_CB_STRING_CHANGED                                  = ( 4 * 1000 + 10);
	public static final int Pt_CB_TEXT_CHANGED                                    = ( 4 * 1000 + 10);
	public static final int Pt_CB_TIMER_ACTIVATE                                  = ( 41 * 1000 + 2 );
//public static final int Pt_CB_TREE_SELECTION                                  = ( 23 * 1000 + 22 );
//public static final int Pt_CB_TREE_STATE                                      = ( 23 * 1000 + 21 );
	public static final int Pt_CB_UNREALIZED                                      = ( 1 * 1000 + 13 );
	public static final int Pt_CB_WINDOW                                          = ( 18 * 1000 + 17 );
//public static final int Pt_CB_WINDOW_CLOSING                                  = ( 18 * 1000 + 24 );
//public static final int Pt_CB_WINDOW_OPENING                                  = ( 18 * 1000 + 23 );
//public static final int Pt_CB_WINDOW_TRANSPORT                                = ( 18 * 1000 + 21 );
	public static final int Pt_CENTER                                             = 2;
//public static final int Pt_CHANGE_ACTIVATE                                    = 0x00000020;
//public static final int Pt_CHANGE_INVISIBLE                                   = 0;
//public static final int Pt_CHECK                                              = 5;
//public static final int Pt_CHILD_CREATED                                      = 0x01000000;
//public static final int Pt_CHILD_DESTROYED                                    = 0x00800000;
//public static final int Pt_CHILD_GETTING_FOCUS                                = 0x10000000;
//public static final int Pt_CHILD_GETTING_RESOURCE                             = 0x80000000;
//public static final int Pt_CHILD_LOSING_FOCUS                                 = 0x20000000;
//public static final int Pt_CHILD_LOST_FOCUS                                   = 0x20000000;
//public static final int Pt_CHILD_MOVED_RESIZED                                = 0x08000000;
//public static final int Pt_CHILD_REALIZED                                     = 0x02000000;
//public static final int Pt_CHILD_REDIRECTOR                                   = 0x00400000;
//public static final int Pt_CHILD_SETTING_RESOURCE                             = 0x40000000;
//public static final int Pt_CHILD_UNREALIZED                                   = 0x04000000;
//public static final int Pt_CLEAN_RESOURCES                                    = 0x00000010;
//public static final int Pt_CLEAR                                              = 0x00010000;
//public static final int Pt_CLIENT_GETEVENTS                                   = 0x0001;
//public static final int Pt_CLIENT_NEEDEVENTS                                  = 0x0002;
//public static final int Pt_CLIENT_NOEVENTS                                    = 0x0002;
//public static final int Pt_CLIENT_NONBLOCK                                    = 0x0001;
//public static final int Pt_CLIP_HIGHLIGHT                                     = 0x00000010;
//public static final int Pt_CLOCK_24_HOUR                                      = 4;
//public static final int Pt_CLOCK_ANALOG                                       = 1;
//public static final int Pt_CLOCK_CURRENT                                      = -1;
//public static final int Pt_CLOCK_DIGITAL                                      = 0;
//public static final int Pt_CLOCK_HOUR_CHANGED                                 = 1;
//public static final int Pt_CLOCK_LED                                          = 2;
//public static final int Pt_CLOCK_MINUTE_CHANGED                               = 2;
//public static final int Pt_CLOCK_PAD_HOURS                                    = 32;
//public static final int Pt_CLOCK_SECOND_CHANGED                               = 4;
//public static final int Pt_CLOCK_SHOW_AMPM                                    = 16;
//public static final int Pt_CLOCK_SHOW_NUMBERS                                 = 8;
//public static final int Pt_CLOCK_SHOW_SECONDS                                 = 2;
//public static final int Pt_CLOCK_TRACK_TIME                                   = 1;
//public static final int Pt_CMT_IN_UPDATE                                      = 0x80000000;
//public static final int Pt_CMT_SCROLL_CB_ACTIVE                               = 0x40000000;
//public static final int Pt_COMBOBOX_ALT_DOWN                                  = 0x00000100;
//public static final int Pt_COMBOBOX_EXTENTING                                 = 0x20000000;
//public static final int Pt_COMBOBOX_MAX_WIDTH                                 = 0x00000080;
//public static final int Pt_COMBOBOX_ON_BOTTOM                                 = 0x40000000;
//public static final int Pt_COMBOBOX_OPEN                                      = 0x80000000;
	public static final int Pt_COMBOBOX_STATIC                                    = 0x00000020;
//public static final int Pt_COMBOBOX_TOP                                       = 0x00000040;
//public static final int Pt_COMPOUND                                           = 0x00000100;
//public static final int Pt_CONNECTION_NOTIFY_FLUSH                            = 4;
//public static final int Pt_CONNECTION_NOTIFY_NOFLUSH                          = 2;
//public static final int Pt_CONNECTION_NOTIFY_RESIZE                           = 1;
//public static final int Pt_CONSUME_EVENTS                                     = 0x0001;
//public static final int Pt_CONTAINER                                          = 0x00000001;
//public static final int Pt_CONTAINER_ANCHORING                                = 0x20000000;
//public static final int Pt_CONTAINER_CONSTRAINT_BITS                          = 0xFFFF0000;
//public static final int Pt_CONTAINER_FLAGS_MASK                               = 0x00001fff;
//public static final int Pt_CONTAINER_RESIZING                                 = 0x01000000;
	public static final int Pt_CONTINUE                                           = 0;
//public static final int Pt_CURSOR_IN_CONTAINER                                = 0x00001000;
//public static final int Pt_CURSOR_VISIBLE                                     = 0x00000001;
//public static final int Pt_DAMAGE_FAMILY                                      = 0x00040000;
//public static final int Pt_DAMAGE_ON_FOCUS                                    = 0x8000;
//public static final int Pt_DAMAGE_PARENT                                      = 0x4000;
//public static final int Pt_DAMAGED                                            = 0x00002000;
//public static final int Pt_DB_INLINE_IMAGE                                    = 0x00000001;
	public static final int Pt_DEFAULT_COLOR                                      = (-3);
//public static final int Pt_DEFAULT_FONT                                       = (0);
	public static final int Pt_DELAY_ACTIVATION                                   = 0x00000040;
	public static final int Pt_DELAY_REALIZE                                      = Pt_DELAY_ACTIVATION;
//public static final int Pt_DESTROYED                                          = 0x00001000;
//public static final int Pt_DISABLE_BALLOONS                                   = 0x00000008;
//public static final int Pt_DISCONTINUOUS                                      = 0x00000004;
//public static final int Pt_DISJOINT                                           = 0x00000080;
//public static final int Pt_DIVIDER_CASCADE                                    = 0x0008;
//public static final int Pt_DIVIDER_INVISIBLE                                  = 0x0004;
//public static final int Pt_DIVIDER_NORESIZE                                   = 0x0001;
//public static final int Pt_DIVIDER_RESIZE_BOTH                                = 0x0002;
//public static final int Pt_DOOMED                                             = 0x0800;
//public static final int Pt_DOUBLE_DASH_LINE                                   = 3;
//public static final int Pt_DOUBLE_LINE                                        = 1;
//public static final int Pt_DOUBLE_ULINE                                       = 2;
//public static final int Pt_DRAW_COPY_RECTS                                    = 0x0010;
//public static final int Pt_DRAW_DEFAULT                                       = 0x0000;
//public static final int Pt_DRAW_MODE_MASK                                     = 0x000F;
//public static final int Pt_DRAW_OVERWRITE                                     = 0x0001;
//public static final int Pt_DRAW_RAW                                           = 0x0002;
//public static final int Pt_DRAW_START                                         = 0x0003;
//public static final int Pt_DYNAMIC                                            = 0;
//public static final int Pt_EDIT_ACTIVATE                                      = 1;
	public static final int Pt_EDITABLE                                           = 0x00000002;
//public static final int Pt_EMT_AUTOINDENT                                     = 0x00000010;
	public static final int Pt_EMT_CHAR                                           = 0x02;
//public static final int Pt_EMT_DISABLE_PURGE                                  = 0x40000000;
//public static final int Pt_EMT_FOCUSED                                        = 0x20000000;
//public static final int Pt_EMT_FORCED_SCROLL                                  = 0x00000040;
//public static final int Pt_EMT_FULL_LINES                                     = 0x00000020;
	public static final int Pt_EMT_NEWLINE                                        = 0x04;
//public static final int Pt_EMT_NO_TABS                                        = 0x00000080;
//public static final int Pt_EMT_READ_ONLY_FLAGS                                = Pt_EMT_DISABLE_PURGE | Pt_EMT_FOCUSED;
//public static final int Pt_EMT_SCROLL_TO_CURSOR                               = 0x80000000;
	public static final int Pt_EMT_WORD                                           = 0x01;
	public static final int Pt_ENABLE_CUA                                         = 0x00000010;
	public static final int Pt_ENABLE_CUA_ARROWS                                  = 0x00000020;
	public static final int Pt_END                                                = 2;
//public static final int Pt_ESC_DISABLE                                        = 0x8;
//public static final int Pt_ETCH_HIGHLIGHT                                     = 0x00000200;
	public static final int Pt_ETCHED_IN                                          = 4;
	public static final int Pt_ETCHED_OUT                                         = 5;
//public static final int Pt_EV_REDIRECTED                                      = (Ph_EV_BUT_PRESS|Ph_EV_BUT_RELEASE|Ph_EV_KEY|Ph_EV_BUT_REPEAT);
	public static final int Pt_EXTENDED_MODE                                      = 4;
//public static final int Pt_FALSE                                              = 0;
//public static final int Pt_FD_DRAIN                                           = 0x00000001;
//public static final int Pt_FD_NOPOLL                                          = 0x8;
//public static final int Pt_FD_OBAND                                           = 0x40000000;
//public static final int Pt_FD_READ                                            = 0x10000000;
//public static final int Pt_FD_WRITE                                           = 0x20000000;
//public static final int Pt_FEP_PRESENT                                        = 0x00000002;
//public static final int Pt_FEP_QUERIED                                        = 0x00000004;
//public static final int Pt_FLOAT_ORIGIN                                       = 0x02;
//public static final int Pt_FLOAT_POS                                          = 0x01;
//public static final int Pt_FOCUS_RENDER                                       = 0x02000000;
//public static final int Pt_FONTSEL_AA_CHECK                                   = 0x01;
//public static final int Pt_FONTSEL_ALL_FONTS                                  = PHFONT_ALL_FONTS;
//public static final int Pt_FONTSEL_ALL_SYMBOLS                                = PHFONT_ALL_SYMBOLS;
//public static final int Pt_FONTSEL_BITMAP                                     = PHFONT_BITMAP;
//public static final int Pt_FONTSEL_FIXED                                      = PHFONT_FIXED;
//public static final int Pt_FONTSEL_PROP                                       = PHFONT_PROP;
//public static final int Pt_FONTSEL_SAMPLE                                     = 0x02;
//public static final int Pt_FONTSEL_SCALABLE                                   = PHFONT_SCALABLE;
//public static final int Pt_FORCE_UNREALIZE                                    = 0x00000040;
//public static final int Pt_FREE_MEMORY                                        = 0x20000000;
//public static final int Pt_FS_DIR_CL                                          = 1;
//public static final int Pt_FS_DIR_OP                                          = 0;
//public static final int Pt_FS_DLINK_CL                                        = 3;
//public static final int Pt_FS_DLINK_OP                                        = 2;
//public static final int Pt_FS_ERROR                                           = 6;
//public static final int Pt_FS_FILE                                            = 4;
//public static final int Pt_FS_FLINK                                           = 5;
//public static final int Pt_FS_FREE_ON_COLLAPSE                                = 0x10;
//public static final int Pt_FS_NEW_DIR                                         = 0;
//public static final int Pt_FS_NEW_ITEM                                        = 1;
//public static final int Pt_FS_NO_ROOT_DISPLAY                                 = 0x80;
//public static final int Pt_FS_OLD_DIR                                         = 1;
//public static final int Pt_FS_OLD_ITEM                                        = -1;
//public static final int Pt_FS_SEEK_KEY                                        = 0x30;
//public static final int Pt_FS_SHOW_DIRS                                       = 0x1;
//public static final int Pt_FS_SHOW_ERRORS                                     = 0x8;
//public static final int Pt_FS_SHOW_FILES                                      = 0x2;
//public static final int Pt_FS_SHOW_HIDDEN                                     = 0x4;
//public static final int Pt_FS_SINGLE_LEVEL                                    = 0x20;
//public static final int Pt_FS_ALL_FLAGS                                       = Pt_FS_SHOW_DIRS|Pt_FS_SHOW_FILES|Pt_FS_SHOW_HIDDEN|Pt_FS_SHOW_ERRORS|Pt_FS_FREE_ON_COLLAPSE|Pt_FS_SINGLE_LEVEL|Pt_FS_SEEK_KEY;
//public static final int Pt_FS_STATE_END                                       = 2;
//public static final int Pt_FS_STATE_START                                     = 1;
//public static final int Pt_FSDIALOG_BTN1                                      = 1;
	public static final int Pt_FSDIALOG_BTN2                                      = 2;
//public static final int Pt_FSDIALOG_CANCEL                                    = 1;
//public static final int Pt_FSDIALOG_NO_DIRS                                   = 0x10;
//public static final int Pt_FSDIALOG_NO_FCHECK                                 = 0x1;
//public static final int Pt_FSDIALOG_NO_FILES                                  = 0x20;
//public static final int Pt_FSDIALOG_NO_FSPEC                                  = 0x4;
//public static final int Pt_FSDIALOG_NO_UP_BUTTON                              = 0x4;
//public static final int Pt_FSDIALOG_OPEN                                      = 2;
//public static final int Pt_FSDIALOG_SHOW_HIDDEN                               = 0x8;
	public static final int Pt_GAUGE_INDETERMINATE                				= 0x80;
//public static final int Pt_GAUGE_MAX_ON_BOTTOM                                = 1;
//public static final int Pt_GAUGE_MAX_ON_LEFT                                  = 1;
//public static final int Pt_GAUGE_MAX_ON_RIGHT                                 = 0;
//public static final int Pt_GAUGE_MAX_ON_TOP                                   = 0;
//public static final int Pt_GAUGE_LIVE                                       = 0x40;
//public static final int Pt_GEN_LIST_FULL_WIDTH                                = 0x08;
//public static final int Pt_GEN_LIST_ITEM_BACKGROUND                           = 0x20;
//public static final int Pt_GEN_LIST_NO_AUTOFOCUS                              = 0x10;
//public static final int Pt_GEN_LIST_NO_BACKGROUND                             = 0x01;
//public static final int Pt_GEN_LIST_NO_CLIPPING                               = 0x02;
//public static final int Pt_GEN_LIST_SHOW_DAMAGED                              = 0x04;
	public static final int Pt_GETS_FOCUS                                         = 0x00000400;
	public static final int Pt_GHOST                                              = 0x01000000;
//public static final int Pt_GROUP_ASIS                                         = 2;
	public static final int Pt_GROUP_EQUAL_SIZE                                   = 0x00000002;
//public static final int Pt_GROUP_EQUAL_SIZE_HORIZONTAL                        = 0x00000100;
	public static final int Pt_GROUP_EQUAL_SIZE_VERTICAL                          = 0x00000200;
//public static final int Pt_GROUP_EXCLUSIVE                                    = 0x00000001;
	public static final int Pt_GROUP_HORIZONTAL                                   = 0;
//public static final int Pt_GROUP_HORZ_CENTER                                  = 0;
//public static final int Pt_GROUP_HORZ_LEFT                                    = 1;
//public static final int Pt_GROUP_HORZ_NONE                                    = -1;
	public static final int Pt_GROUP_HORZ_RIGHT                                   = 2;
//public static final int Pt_GROUP_NO_KEY_WRAP_HORIZONTAL                       = 0x00000010;
//public static final int Pt_GROUP_NO_KEY_WRAP_VERTICAL                         = 0x00000020;
//public static final int Pt_GROUP_NO_KEY_WRAP                                  = (Pt_GROUP_NO_KEY_WRAP_HORIZONTAL | Pt_GROUP_NO_KEY_WRAP_VERTICAL );
//public static final int Pt_GROUP_NO_KEYS                                      = 0x00000008;
//public static final int Pt_GROUP_NO_SELECT_ALLOWED                            = 0x00000004;
//public static final int Pt_GROUP_STRETCH_FILL                                 = 0x00001000;
//public static final int Pt_GROUP_STRETCH_HORIZONTAL                           = 0x00000400;
//public static final int Pt_GROUP_STRETCH_VERTICAL                             = 0x00000800;
//public static final int Pt_GROUP_STRETCH                                      = (Pt_GROUP_STRETCH_VERTICAL|Pt_GROUP_STRETCH_HORIZONTAL);
//public static final int Pt_GROUP_VERT_BOTTOM                                  = 2;
	public static final int Pt_GROUP_VERT_CENTER                                  = 0;
//public static final int Pt_GROUP_VERT_NONE                                    = -1;
//public static final int Pt_GROUP_VERT_TOP                                     = 1;
//public static final int Pt_GROUP_VERTICAL                                     = 1;
//public static final int Pt_HALT                                               = 1;
	public static final int Pt_HIGHLIGHTED                                        = 0x00000100;
	public static final int Pt_HORIZONTAL                                         = 1;
//public static final int Pt_HOTKEY_IGNORE_MODS                                 = 0x0002;
//public static final int Pt_HOTKEY_SYM                                         = 0x0001;
//public static final int Pt_HOTKEY_TERMINATOR                                  = 0x00000004;
//public static final int Pt_HOTKEYS_FIRST                                      = 0x00000080;
//public static final int Pt_HTML_DISPLAY                                       = 0x01;
//public static final int Pt_HTML_LOAD                                          = 0x08;
//public static final int Pt_HTML_PAGE                                          = 0x10;
//public static final int Pt_HTML_PAGE_MODE                                     = 0x2;
//public static final int Pt_HTML_REDIRECT                                      = 0x04;
//public static final int Pt_HTML_RELOAD                                        = 0x1;
//public static final int Pt_HTML_RESIZE                                        = 0x02;
//public static final int Pt_IGNORE_CONSTRAINTS                                 = 0x00008000;
	public static final int Pt_IMAGE                                              = 0x04;
//public static final int Pt_IMAGEAREA_AUTOSCALE                                = 0x2;
//public static final int Pt_IMAGEAREA_COMPLETE                                 = 3;
//public static final int Pt_IMAGEAREA_DRAG                                     = 2;
//public static final int Pt_IMAGEAREA_EDITABLE_SELECTION                       = 0x8;
//public static final int Pt_IMAGEAREA_ENABLE_SELECTION                         = 0x4;
//public static final int Pt_IMAGEAREA_IMGCRC_VALID                             = 0x1;
//public static final int Pt_IMAGEAREA_INIT                                     = 1;
//public static final int Pt_IMAGEAREA_NO_MEMORY                                = 0x10;
//public static final int Pt_IMAGEAREA_PALCRC_VALID                             = 0x2;
//public static final int Pt_IMAGEAREA_RENDERED                                 = 0x1;
//public static final int Pt_IMAGEAREA_SCROLLED_X                               = 1;
//public static final int Pt_IMAGEAREA_SCROLLED_Y                               = 2;
//public static final int Pt_IMMEDIATE_CHILD                                    = 1;
//public static final int Pt_IN_EXPOSE                                          = 0x00000008;
//public static final int Pt_IN_FLUX                                            = 0x00008000;
//public static final int Pt_INDEX_RESOURCES                                    = 0x00000020;
//public static final int Pt_INFLATE_BALLOON                                    = 0;
//public static final int Pt_INHERIT_COLOR                                      = (-4);
//public static final int Pt_INHERIT_FONT                                       = (-1);
	public static final int Pt_INITIAL                                            = 0x04;
//public static final int Pt_INITIALIZED                                        = 0x04000000;
//public static final int PT_INPUT_ID                                           = 1;
//public static final int Pt_INSERT_MODE                                        = 0x00000008;
//public static final int Pt_INTERNAL_HELP                                      = 0x0002;
//public static final int Pt_LABEL_SELECT_SHIFT                                 = 0x01;
	public static final int Pt_LEFT                                               = 0;
	public static final int Pt_LEFT_ANCHORED_LEFT                                 = 0x00000100;
	public static final int Pt_LEFT_ANCHORED_RELATIVE                             = 0x00000001;
	public static final int Pt_LEFT_ANCHORED_RIGHT                                = 0x00000010;
	public static final int Pt_LEFT_IS_ANCHORED                                   = Pt_LEFT_ANCHORED_LEFT | Pt_LEFT_ANCHORED_RELATIVE | Pt_LEFT_ANCHORED_RIGHT;
//public static final int Pt_LINK_DELETE                                        = -2;
//public static final int Pt_LINK_INSERT                                        = -1;
//public static final int Pt_LIST_BALLOON_AS_REQUIRED                           = 0x0040;
//public static final int Pt_LIST_BALLOON_CENTER                                = (-3);
//public static final int Pt_LIST_BALLOON_LEFT                                  = (-1);
//public static final int Pt_LIST_BALLOON_MASK                                  = 0x0060;
//public static final int Pt_LIST_BALLOON_NEVER                                 = 0x0000;
//public static final int Pt_LIST_BALLOON_REGISTERED                            = 0x0080;
//public static final int Pt_LIST_BALLOON_RIGHT                                 = (-2);
//public static final int Pt_LIST_BALLOONS_IN_COLUMNS                           = 0x1000;
//public static final int Pt_LIST_BOUNDARY_KEY_EVENTS                           = 0x2000;
//public static final int Pt_LIST_COLUMN_ALIGNMENT                              = ( Pg_TEXT_LEFT | Pg_TEXT_RIGHT | Pg_TEXT_CENTER );
//public static final int Pt_LIST_COLUMN_CENTER                                 = Pg_TEXT_CENTER;
//public static final int Pt_LIST_COLUMN_DAMAGE_ALWAYS                          = 0x0001;
//public static final int Pt_LIST_COLUMN_LEFT                                   = Pg_TEXT_LEFT;
//public static final int Pt_LIST_COLUMN_RIGHT                                  = Pg_TEXT_RIGHT;
//public static final int Pt_LIST_FIND_STRING                                   = 6;
//public static final int Pt_LIST_GOTO_POS                                      = 10;
//public static final int Pt_LIST_HEADER_AUTORESIZE                             = 0x0400;
//public static final int Pt_LIST_INACTIVE                                      = 0x0004;
//public static final int Pt_LIST_INSERT_ITEMS                                  = 1;
//public static final int Pt_LIST_ITEM_ABOVE                                    = 0x010;
//public static final int Pt_LIST_ITEM_BELOW                                    = 0x020;
//public static final int Pt_LIST_ITEM_CURRENT                                  = 0x002;
//public static final int Pt_LIST_ITEM_DAMAGED                                  = 0x008;
//public static final int Pt_LIST_ITEM_DISABLED                                 = 0x004;
//public static final int Pt_LIST_ITEM_NOCOLUMNS                                = 0x200;
//public static final int Pt_LIST_ITEM_SAVED                                    = 0x100;
//public static final int Pt_LIST_ITEM_SELECTED                                 = 0x001;
//public static final int Pt_LIST_ITEM_USED_FLAGS                               = 0x33F;
//public static final int Pt_LIST_MOD_LONG_POSITIONS                            = 5;
//public static final int Pt_LIST_MOD_RANGE                                     = 3;
//public static final int Pt_LIST_MOD_SHORT_POSITIONS                           = 4;
//public static final int Pt_LIST_MOD_STRINGS                                   = 2;
//public static final int Pt_LIST_NOBLIT                                        = 0x0200;
//public static final int Pt_LIST_NON_SELECT                                    = 0x0008;
//public static final int Pt_LIST_REMOVE_ALL_ITEMS                              = 0;
//public static final int Pt_LIST_SCROLL_LIST                                   = 0x00;
//public static final int Pt_LIST_SCROLL_SCROLLBAR                              = 0x01;
	public static final int Pt_LIST_SCROLLBAR_ALWAYS                              = 0x0001;
	public static final int Pt_LIST_SCROLLBAR_AS_REQUIRED                         = 0x0002;
//public static final int Pt_LIST_SCROLLBAR_AUTORESIZE                          = 0x0800;
//public static final int Pt_LIST_SCROLLBAR_GETS_FOCUS                          = 0x0100;
//public static final int Pt_LIST_SCROLLBAR_MASK                                = 0x0003;
//public static final int Pt_LIST_SCROLLBAR_NEVER                               = 0x0000;
//public static final int Pt_LIST_SELECT_POS                                    = 7;
//public static final int Pt_LIST_SELECTION_BROWSE                              = 0x01;
//public static final int Pt_LIST_SELECTION_CANCEL                              = 0x02;
	public static final int Pt_LIST_SELECTION_FINAL                               = 0x00;
//public static final int Pt_LIST_SHOW_BALLOON                                  = 0x0020;
//public static final int Pt_LIST_SHOW_POS                                      = 9;
//public static final int Pt_LIST_SNAP                                          = 0x0010;
//public static final int Pt_LIST_UNSELECT_POS                                  = 8;
//public static final int Pt_MAX_ON_BOTTOM                                      = 1;
//public static final int Pt_MAX_ON_LEFT                                        = 0;
//public static final int Pt_MAX_ON_RIGHT                                       = 1;
//public static final int Pt_MAX_ON_TOP                                         = 0;
	public static final int Pt_MENU_AUTO                                          = 0x00000001;
//public static final int Pt_MENU_BAR                                           = 1;
	public static final int Pt_MENU_BUTTON                                        = 0x00000800;
	public static final int Pt_MENU_CHILD                                         = 0x00000008;
	public static final int Pt_MENU_DOWN                                          = 3;
//public static final int Pt_MENU_END_RELEASE                                   = 0x40000000;
//public static final int Pt_MENU_FOCUS                                         = 0x20000000;
//public static final int Pt_MENU_GOT_FOCUS                                     = 0x10000000;
//public static final int Pt_MENU_NAVIGATE                                      = 1;
//public static final int Pt_MENU_ON_LEFT                                       = 0x08000000;
//public static final int Pt_MENU_ON_TOP                                        = 0x04000000;
//public static final int Pt_MENU_PDR_ON                                        = 0x80000000;
	public static final int Pt_MENU_RIGHT                                         = 2;
//public static final int Pt_MENU_TEAR_OFF                                      = 0x00000004;
	public static final int Pt_MENU_TEXT                                          = 0;
//public static final int Pt_MENU_TRANSIENT                                     = 0x00000002;
//public static final int Pt_MENU_UP                                            = 4;
//public static final int Pt_MENUABLE                                           = 0x08000000;
//public static final int Pt_MENUBAR_LAST_R_ALIGNED                             = 0x0001;
//public static final int Pt_MENUBAR_MENU_OPEN                                  = 0x8000;
//public static final int Pt_MERGE_NEXT                                         = 0x80000000;
//public static final int Pt_MERGE_PREV                                         = 0x40000000;
	public static final int Pt_MODAL                                              = 0x4;
//public static final int Pt_MSG_CENTER_ON_PARENT                               = 0x1;
//public static final int Pt_MSG_FONT_ON_BUTTONS                                = 0x2;
//public static final int Pt_MT_ALIGN_BITS                                      = 0x00000007;
//public static final int Pt_MT_BACKGROUND                                      = 0x0004;
//public static final int Pt_MT_BACKGROUND_COLOR                                = 0x0004;
//public static final int Pt_MT_CENTER                                          = 0x00000002;
//public static final int Pt_MT_FLAGS                                           = 0x0010;
//public static final int Pt_MT_FONT                                            = 0x0001;
//public static final int Pt_MT_FOREGROUND                                      = 0x0002;
//public static final int Pt_MT_LEFT                                            = 0x00000004;
//public static final int Pt_MT_QUERY_CHAR                                      = 0;
//public static final int Pt_MT_QUERY_LINE                                      = 1;
//public static final int Pt_MT_RIGHT                                           = 0x00000001;
//public static final int Pt_MT_TAG                                             = 0x0008;
//public static final int Pt_MT_TEXT_COLOR                                      = 0x0002;
//public static final int Pt_MT_UPDATE_POS_ONLY                                 = 4;
//public static final int Pt_MT_UPDATE_X_SCROLLBAR                              = 2;
//public static final int Pt_MT_UPDATE_Y_SCROLLBAR                              = 1;
	public static final int Pt_MULTIPLE_MODE                                      = 2;
//public static final int Pt_MULTITEXT                                          = 0x20;
	public static final int Pt_N_OF_MANY                                          = 0;
	public static final int Pt_NEVER                                              = 0x00;
//public static final int Pt_NO_INHERITED_RESOURCES                             = 0x00000400;
//public static final int Pt_NO_RANGE_SELECTION                                 = 0x00000040;
//public static final int Pt_NO_ULINE                                           = 0;
	public static final int Pt_NOLINE                                             = 6;
//public static final int Pt_NOREDRAW_SET                                       = 0x10000000;
//public static final int Pt_NUMERIC_ACTIVATE                                   = 0x2;
//public static final int Pt_NUMERIC_AUTO_HIGHLIGHT                             = 0x08;
//public static final int Pt_NUMERIC_CHANGED                                    = 0x1;
//public static final int Pt_NUMERIC_ENABLE_UPDOWN                              = 0x01;
//public static final int Pt_NUMERIC_HEXADECIMAL                                = 0x10;
//public static final int Pt_NUMERIC_UPDOWN_ACTIVATE                            = 0x8;
//public static final int Pt_NUMERIC_UPDOWN_REPEAT                              = 0x4;
//public static final int Pt_NUMERIC_USE_SEPARATORS                             = 0x02;
//public static final int Pt_NUMERIC_VALUE_CHANGED                              = 0x80000000;
//public static final int Pt_NUMERIC_WRAP                                       = 0x04;
//public static final int Pt_OBSCURED                                           = 0x00004000;
//public static final int Pt_OCCLUSIVE                                          = 0x00000800;
	public static final int Pt_ONE_OF_MANY                                        = 1;
//public static final int Pt_OPAQUE                                             = 0x00000020;
//public static final int Pt_PANE_XLR_ANCHOR_RIGHT                              = 0x0020;
//public static final int Pt_PANE_XLR_REL                                       = 0x0002;
//public static final int Pt_PANE_XUL_ANCHOR_RIGHT                              = 0x0010;
//public static final int Pt_PANE_XUL_REL                                       = 0x0001;
//public static final int Pt_PANE_YLR_ANCHOR_BOTTOM                             = 0x0080;
//public static final int Pt_PANE_YLR_REL                                       = 0x0008;
//public static final int Pt_PANE_YUL_ANCHOR_BOTTOM                             = 0x0040;
//public static final int Pt_PANE_YUL_REL                                       = 0x0004;
//public static final int Pt_PASS_END                                           = 3;
//public static final int Pt_PEN_PRESENT                                        = 0x00000001;
//public static final int Pt_POP_BALLOON                                        = 1;
//public static final int Pt_POSITIONING                                        = 1;
//public static final int Pt_PP_NO_RESIZE                                       = 2;
//public static final int Pt_PP_RESIZE_PC                                       = 1;
//public static final int Pt_PP_RESIZE_WIDGET                                   = 0;
//public static final int Pt_PROCREATED                                         = 0x00400000;
	public static final int Pt_RADIO                                              = 2;
	public static final int Pt_RANGE_MODE                                         = 5;
//public static final int Pt_REALIZED                                           = 0x00000001;
//public static final int Pt_REALIZING                                          = 0x80000000;
//public static final int Pt_RECTANGULAR                                        = 0x00000002;
//public static final int Pt_REGION                                             = 0x40000000;
//public static final int Pt_RELATIVE                                           = 0x10;
	public static final int Pt_RESIZE_BITS                                        = 0x07;
//public static final int Pt_RESIZE_WIDTH                                       = 0x00000004;
	public static final int Pt_RESIZE_Y_SHIFT                                     = 20;
	public static final int Pt_RESIZE_X_SHIFT                                     = 23;
	public static final int Pt_RESIZE_X_ALWAYS                                    = (Pt_ALWAYS     << Pt_RESIZE_X_SHIFT);
	public static final int Pt_RESIZE_X_AS_REQUIRED                               = (Pt_AS_REQUIRED << Pt_RESIZE_X_SHIFT);
	public static final int Pt_RESIZE_X_BITS                                      = (Pt_RESIZE_BITS   << Pt_RESIZE_X_SHIFT);
	public static final int Pt_RESIZE_X_INITIAL                                   = (Pt_INITIAL    << Pt_RESIZE_X_SHIFT);
	public static final int Pt_RESIZE_Y_ALWAYS                                    = (Pt_ALWAYS     << Pt_RESIZE_Y_SHIFT);
	public static final int Pt_RESIZE_Y_AS_REQUIRED                               = (Pt_AS_REQUIRED << Pt_RESIZE_Y_SHIFT);
	public static final int Pt_RESIZE_Y_BITS                                      = (Pt_RESIZE_BITS   << Pt_RESIZE_Y_SHIFT);
	public static final int Pt_RESIZE_Y_INITIAL                                   = (Pt_INITIAL    << Pt_RESIZE_Y_SHIFT);
//public static final int Pt_RESIZE_XY_ALWAYS                                   = (Pt_RESIZE_X_ALWAYS |Pt_RESIZE_Y_ALWAYS);
	public static final int Pt_RESIZE_XY_AS_REQUIRED                              = (Pt_RESIZE_X_AS_REQUIRED|Pt_RESIZE_Y_AS_REQUIRED);
	public static final int Pt_RESIZE_XY_BITS                                     = (Pt_RESIZE_X_BITS |Pt_RESIZE_Y_BITS);
//public static final int Pt_RESIZE_XY_INITIAL                                  = (Pt_RESIZE_X_INITIAL |Pt_RESIZE_Y_INITIAL);
	public static final int Pt_RIGHT                                              = 1;
	public static final int Pt_RIGHT_ANCHORED_LEFT                                = 0x00000200;
	public static final int Pt_RIGHT_ANCHORED_RELATIVE                            = 0x00000002;
	public static final int Pt_RIGHT_ANCHORED_RIGHT                               = 0x00000020;
	public static final int Pt_RIGHT_IS_ANCHORED                               = Pt_RIGHT_ANCHORED_LEFT | Pt_RIGHT_ANCHORED_RELATIVE | Pt_RIGHT_ANCHORED_RIGHT;
//public static final int Pt_ROUND                                              = 3;
//public static final int Pt_SCROLL_AREA_IGNORE_KEYS                            = 0x0001;
//public static final int Pt_SCROLL_AREA_RO_FLAGS                               = 0x0000;
//public static final int Pt_SCROLL_AREA_TRACK_FOCUS                            = 0x0002;
	public static final int Pt_SCROLL_DECREMENT                                   = 1;
//public static final int Pt_SCROLL_DECREMENT_PRESSED                           = 0x2000;
	public static final int Pt_SCROLL_DRAGGED                                     = 7;
//public static final int Pt_SCROLL_HORIZONTAL                                  = 0;
	public static final int Pt_SCROLL_INCREMENT                                   = 2;
//public static final int Pt_SCROLL_INCREMENT_PRESSED                           = 0x4000;
//public static final int Pt_SCROLL_INVERTED                                    = 2;
	public static final int Pt_SCROLL_PAGE_DECREMENT                              = 4;
	public static final int Pt_SCROLL_PAGE_INCREMENT                              = 3;
//public static final int Pt_SCROLL_PRESSED_MASK                                = 0xe000;
//public static final int Pt_SCROLL_RELEASED                                    = 8;
//public static final int Pt_SCROLL_RESTART_DRAG                                = 0x1000;
//public static final int Pt_SCROLL_SET                                         = 9;
//public static final int Pt_SCROLL_SHOW_ARROWS                                 = 1;
//public static final int Pt_SCROLL_SLIDER_PRESSED                              = 0x8000;
	public static final int Pt_SCROLL_TO_MAX                                      = 5;
	public static final int Pt_SCROLL_TO_MIN                                      = 6;
//public static final int Pt_SCROLLAREA_EXTENTING                               = 0x8000;
//public static final int Pt_SCROLLBAR_FOCUSED                                  = 0x0080;
//public static final int Pt_SCROLLBAR_HORIZONTAL                               = 0x0001;
//public static final int Pt_SCROLLBAR_INVERTED                                 = 0x0004;
//public static final int Pt_SCROLLBAR_NOTIFY_ONLY                              = 0x0008;
//public static final int Pt_SCROLLBAR_SHOW_ARROWS                              = 0x0002;
	public static final int Pt_SELECT_NOREDRAW                                    = 0x00080000;
	public static final int Pt_SELECTABLE                                         = 0x00000080;
	public static final int Pt_SELECTION_MODE_AUTO                                = 0x8200;
//public static final int Pt_SELECTION_MODE_COMPOSE_FLAG                        = 0x8000;
//public static final int Pt_SELECTION_MODE_COMPOSE_MASK                        = 0x9FF0;
	public static final int Pt_SELECTION_MODE_MULTIPLE                            = 0x8000;
	public static final int Pt_SELECTION_MODE_NOCLEAR                             = 0x8400;
	public static final int Pt_SELECTION_MODE_NOFOCUS                             = 0x9000;
	public static final int Pt_SELECTION_MODE_NOMOVE                              = 0x8080;
//public static final int Pt_SELECTION_MODE_NONE                                = 0x8030;
//public static final int Pt_SELECTION_MODE_NOREST                              = 0x8100;
	public static final int Pt_SELECTION_MODE_NOSCROLL                            = 0x8040;
	public static final int Pt_SELECTION_MODE_RANGE                               = 0x8010;
	public static final int Pt_SELECTION_MODE_SINGLE                              = 0x8020;
	public static final int Pt_SELECTION_MODE_TOGGLE                              = 0x8800;
	public static final int Pt_SEP_HORIZONTAL                                     = 1;
//public static final int Pt_SEP_HORIZONTAL_F                                   = 1;
//public static final int Pt_SEP_ORIENTATION                                    = 0x01;
	public static final int Pt_SEP_VERTICAL                                       = 0;
	public static final int Pt_SET                                                = 0x00000002;
//public static final int Pt_SHOW_BALLOON                                       = 0x04;
//public static final int Pt_SHOW_VALUE                                         = 0x10;
//public static final int Pt_SHOW_VALUE_BOTTOM                                  = 0x20;
//public static final int Pt_SHOW_VALUE_CENTER                                  = 0xc0;
//public static final int Pt_SHOW_VALUE_LEFT                                    = 0x40;
//public static final int Pt_SHOW_VALUE_MASK                                    = 0xf0;
//public static final int Pt_SHOW_VALUE_RIGHT                                   = 0x80;
//public static final int Pt_SHOW_VALUE_TOP                                     = 0x10;
//public static final int Pt_SINGLE_DASH_LINE                                   = 2;
//public static final int Pt_SINGLE_LINE                                        = 0;
//public static final int Pt_SINGLE_MODE                                        = 1;
//public static final int Pt_SINGLE_ULINE                                       = 1;
//public static final int Pt_SKIP_CHILDREN                                      = 0x2000;
//public static final int Pt_SLIDER_IMAGE                                       = 0x80;
//public static final int Pt_SLIDER_MASK                                        = 0x70;
//public static final int Pt_SLIDER_MIN_ON_BOTTOM                               = 1;
//public static final int Pt_SLIDER_MIN_ON_LEFT                                 = 0;
//public static final int Pt_SLIDER_MIN_ON_RIGHT                                = 1;
//public static final int Pt_SLIDER_MIN_ON_TOP                                  = 0;
//public static final int Pt_SLIDER_POINT_DOWN                                  = 0x40;
//public static final int Pt_SLIDER_POINT_LEFT                                  = 0x20;
//public static final int Pt_SLIDER_POINT_RIGHT                                 = 0x40;
//public static final int Pt_SLIDER_POINT_UP                                    = 0x20;
//public static final int Pt_SLIDER_X1_RESOURCES                                = 1;
//public static final int Pt_SUBORDINATES_CHILD                                 = 2;
//public static final int Pt_SUPER_CONSTRAINTS                                  = 0x00000800;
//public static final int Pt_SYSINFO_VALID                                      = 0x00002000;
//public static final int Pt_TAB_UPSIDE_DOWN                                    = 0x1;
//public static final int Pt_TEXT_AUTO_HIGHLIGHT                                = 0x00000080;
//public static final int Pt_TEXT_CHANGED                                       = 0x80000000;
//public static final int Pt_TEXT_FULL                                          = 0x00000010;
	public static final int Pt_TEXT_IMAGE                                         = 0x08;
//public static final int Pt_TEXT_RANGE_ACTIVE                                  = 0x40000000;
//public static final int Pt_TEXT_X1_RESOURCES                                  = 1;
	public static final int Pt_TICK                                               = 4;
//public static final int Pt_TICKS_ETCHED_IN                                    = 0x10;
//public static final int Pt_TICKS_ETCHED_OUT                                   = 0x08;
//public static final int Pt_TICKS_MASK                                         = 0x03;
//public static final int Pt_TICKS_ON_BOTTOM                                    = 0x02;
//public static final int Pt_TICKS_ON_LEFT                                      = 0x01;
//public static final int Pt_TICKS_ON_RIGHT                                     = 0x02;
//public static final int Pt_TICKS_ON_TOP                                       = 0x01;
//public static final int Pt_TICKS_TOUCH_TROUGH                                 = 0x04;
//public static final int Pt_TIMER_INITIAL                                      = 1;
//public static final int Pt_TIMER_REPEAT                                       = 2;
	public static final int Pt_TOGGLE                                             = 0x00000008;
	public static final int Pt_TOP                                                = 0;
	public static final int Pt_TOP_ANCHORED_BOTTOM                                = 0x00000040;
//public static final int Pt_TOP_ANCHORED_RELATIVE                              = 0x00000004;
	public static final int Pt_TOP_ANCHORED_TOP                                   = 0x00000400;
//public static final int Pt_TOP_IS_ANCHORED                                   = Pt_TOP_ANCHORED_BOTTOM | Pt_TOP_ANCHORED_RELATIVE | Pt_TOP_ANCHORED_TOP;
//public static final int Pt_TRAVERSE_BACK                                      = 0x00000004;
//public static final int Pt_TRAVERSE_DONE                                      = 0;
//public static final int Pt_TRAVERSE_FORCE                                     = 0x00000008;
//public static final int Pt_TRAVERSE_LAST                                      = 0x00000002;
//public static final int Pt_TRAVERSE_ROOT                                      = 0x00000001;
//public static final int Pt_TRAVERSE_START                                     = 0;
//public static final int Pt_TREE_BALLOON_ON_IMAGE                              = 0x0100;
//public static final int Pt_TREE_BALLOON_ON_TREE                               = 0x0200;
//public static final int Pt_TREE_COLLAPSING                                    = 0;
//public static final int Pt_TREE_EXPANDING                                     = 1;
//public static final int Pt_TREE_HAS_BUTTONS                                   = 0x0001;
//public static final int Pt_TREE_HAS_LINES                                     = 0x0002;
//public static final int Pt_TREE_ITEM_EXPANDABLE                               = 0x0040;
	public static final int Pt_TREE_ITEM_EXPANDED                                 = 0x0080;
//public static final int Pt_TREE_ROOT_LINES                                    = 0x0004;
//public static final int Pt_TREE_TO_LEFT                                       = 0x0010;
//public static final int Pt_TREE_TO_RIGHT                                      = 0x0008;
//public static final int Pt_TRUE                                               = -1;
//public static final int Pt_UCLIP                                              = 0x08000000;
//public static final int Pt_ULINE_ETCHED_IN                                    = 3;
//public static final int Pt_ULINE_ETCHED_OUT                                   = 4;
//public static final int Pt_UNCLEAN_RESOURCES                                  = 0x00000200;
//public static final int Pt_UNUSED                                             = 0x00000008;
//public static final int Pt_USE_ELLIPSIS                                       = 0x20;
//public static final int Pt_VALUE_XOR                                          = 0x20;
//public static final int Pt_VERSION                                            = 1;
public static final int Pt_VERTICAL                                           = 0;
//public static final int Pt_WIDGET_REBUILD                                     = 0x00100000;
//public static final int Pt_WIDGET_RESIZE                                      = 0x00200000;
//public static final int Pt_WIN_REQUEST                                        = 0x1000;
//public static final int Pt_WINDOW_CURSOR_OVERRIDE                             = 0x0002;
//public static final int Pt_WINDOW_EXTENTING                                   = 0x0008;
//public static final int Pt_WINDOW_FORCE_FRONT                                 = 0x0001;
//public static final int Pt_WINDOW_MAXING                                      = 0x8000;
//public static final int Pt_WINDOW_SETTING                                     = 0x0010;
//public static final int Pt_WINDOW_TASKBAR                                     = 0x0004;
//
//public static final int Ph_WM_APP_DEF_MANAGED                                 = ( Ph_WM_CLOSE | Ph_WM_FOCUS | Ph_WM_MENU | Ph_WM_TOFRONT | Ph_WM_TOBACK |
//																				Ph_WM_RESIZE | Ph_WM_MOVE | Ph_WM_HIDE | Ph_WM_MAX | Ph_WM_RESTORE  | Ph_WM_TASKBAR );
//
//public static final int Ph_WM_APP_DEF_NOTIFY                                  = ( 0 );
//public static final int Ph_WM_APP_DEF_RENDER                                  = ( Ph_WM_RENDER_ASAPP | Ph_WM_RENDER_BORDER | 
//																				Ph_WM_RENDER_RESIZE | Ph_WM_RENDER_MOVE | 
//																				Ph_WM_RENDER_TITLE | Ph_WM_RENDER_MENU | 
//																				Ph_WM_RENDER_MIN | Ph_WM_RENDER_MAX );
//
//public static final int Ph_WM_ICON_DEF_MANAGED                                = ( Ph_WM_CLOSE | Ph_WM_FOCUS | Ph_WM_MENU | Ph_WM_TOFRONT | Ph_WM_TOBACK | Ph_WM_MOVE | Ph_WM_ICON | Ph_WM_RESTORE );
//public static final int Ph_WM_ICON_DEF_NOTIFY                                 = ( 0 );
//public static final int Ph_WM_ICON_DEF_RENDER                                 = ( Ph_WM_RENDER_ASICON | Ph_WM_RENDER_BORDER );
//
//public static final int Pt_RO_EFLAGS                                          = (Pt_DAMAGE_ON_FOCUS | Pt_SKIP_CHILDREN | Pt_WIN_REQUEST | Pt_DOOMED );
//public static final int Pt_CONTAINER_RO_FLAGS                                 = (Pt_IGNORE_CONSTRAINTS | Pt_CANVAS_INVALID | Pt_CONTAINER_CONSTRAINT_BITS);
//
//public static final int PT_WORKPROC_ID                                        = 2;
	public static final int Pt_Z_STRING                                           = 0x01;
//public static final int PX_DIRECT_COLOR                                       = 0x04;
//public static final int PX_DODITHER                                           = 0x40;
//public static final int PX_IMAGE                                              = 0x01;
//public static final int PX_IMAGE_BMP                                          = 0x00;
//public static final int PX_IMAGE_GIF                                          = 0x01;
//public static final int PX_IMAGE_JPG                                          = 0x02;
//public static final int PX_IMAGE_PCX                                          = 0x03;
//public static final int PX_IMAGE_PNG                                          = 0x05;
//public static final int PX_IMAGE_TGA                                          = 0x04;
//public static final int PX_IMAGE_TIFF                                         = 0x06;
//public static final int PX_IMAGE_XBM                                          = 0x07;
//public static final int PX_LOAD                                               = 0x00;
//public static final int PX_METHODS                                            = 0x80000000;
//public static final int PX_NORMAL                                             = 0x00;
//public static final int PX_PALETTE                                            = 0x02;
//public static final int PX_QUERY                                              = 0x01;
//public static final int PX_SUPPRESS_CRC                                       = 0x02;
//public static final int PX_SUPPRESS_TAG                                       = 0x02;
//public static final int PX_TRANSPARENT                                        = 0x08;
//public static final int PX_USECOLORS                                          = 0x20;
//public static final int PXCONFIG_CREATE                                       = 0x4;
//public static final int PXCONFIG_FMT_BOOL_ON                                  = 1;
//public static final int PXCONFIG_FMT_BOOL_TRUE                                = 3;
//public static final int PXCONFIG_FMT_BOOL_YES                                 = 2;
//public static final int PXCONFIG_FMT_CHAR_CHAR                                = 11;
//public static final int PXCONFIG_FMT_CHAR_HEX                                 = 12;
//public static final int PXCONFIG_FMT_INT_DECIMAL                              = 21;
//public static final int PXCONFIG_FMT_INT_HEX                                  = 22;
//public static final int PXCONFIG_FMT_STRING                                   = 31;
//public static final int PXCONFIG_READ                                         = 0x0;
//public static final int PXCONFIG_WRITE                                        = 0x1;
//public static final int REMOTE_FLAG_FIXED                                     = 0x0001;
//public static final int REMOTE_FLAG_INITIAL                                   = 0x0002;
//public static final int REMOTE_FLAG_IS_ORIGIN                                 = 0x0004;
//public static final int REMOTE_FLAG_NO_DIM                                    = 0x0008;
//public static final int REMOTE_WM_TITLE                                       = 2;
//public static final int REMOTE_WM_WINDOW                                      = 1;
//public static final int RF_BUF_MALLOCED                                       = 0x0020;
//public static final int RF_CTRL_MALLOCED                                      = 0x0080;
//public static final int RF_DO_PALETTE                                         = 0x0001;
//public static final int RF_DO_RAM                                             = 0x0002;
//public static final int RF_DONT_COPY                                          = 0x0010;
//public static final int RF_DONT_FONTMAP                                       = 0x0008;
//public static final int RF_DRAWFUNCS_AVAILABLE                                = 0x0400;
//public static final int RF_DRAWFUNCS_MALLOCED                                 = 0x0800;
//public static final int RF_FORCE_ANTIALIAS                                    = 0x0004;
//public static final int RF_FUNCS_LOADED                                       = 0x0040;
//public static final int RF_NEVER_ANTIALIAS                                    = 0x0200;
//public static final int RF_ONE2ONE                                            = 0x0100;
//public static final int TTF_STATS                                             = 0x03;
//public static final int UPDOWN_BOT                                            = 2;
//public static final int UPDOWN_BOTTOM                                         = 2;
//public static final int UPDOWN_LEF                                            = 3;
//public static final int UPDOWN_LEFT                                           = 3;
//public static final int UPDOWN_RIGHT                                          = 4;
//public static final int UPDOWN_RIT                                            = 4;
//public static final int UPDOWN_TOP                                            = 1;
//public static final int VKEYMODBIT                                            = 32;
//public static final int WM_CONSWITCH_BACK                                     = 1;
//public static final int WM_CONSWITCH_CONSOLE                                  = 0;
//public static final int WM_CONSWITCH_FWD                                      = 2;
//public static final int WM_CONSWITCH_RID                                      = 3;
//public static final int WM_VERSION                                            = 8;
//
//public static final String Ph_CLIPBOARD_TYPE_TEXT                             = "TEXT";
//public static final String Ph_CURSOR_DEFAULT_FONT                             = "phcursor";
//public static final String PHFONT_ENVVAR                                      = "PHFONT";
//public static final String PHFONT_FDNAME                                      = "/dev/phfont";

public static final int MAX_DESC_LENGTH                                         = 32;
public static final int MAX_FONT_TAG                                            = 80;

public static final native int PfQueryFontInfo (byte[] font, FontQueryInfo info);
public static final native PhRect_t PfExtentWideText(PhRect_t extent, PhPoint_t pos, byte[] font, char[] str, int len);
public static final native PhRect_t PfExtentText(PhRect_t extent, PhPoint_t pos, int font, int str, int len);
public static final native PhRect_t PfExtentText(PhRect_t extent, PhPoint_t pos, byte[] font, byte[] str, int len);
public static final native int PfQueryFonts(int symbol, int flags, int list, int n);
public static final native byte[] PfGenerateFontName(byte[] pkucDescription, int kuiFlags, int kuiSize, byte[] pucBuff);
//public static final native int PfFindFont(byte[] pkucDescription, int kulFlags, int kulSize);
public static final native int PfFreeFont(int ptsID);
public static final native int PfFontDescription(int ptsID);
public static final native int PfFontSize(int ptsID);
public static final native int PfFontFlags(int ptsID);
//public static final native int PfConvertFontID(int ptsID);
public static final native int PfDecomposeStemToID(byte [] pkszStem);

public static final native PhRect_t PgExtentMultiText(PhRect_t extent, PhPoint_t pos, byte[] font, byte[] str, int n, int linespacing);

public static final native int PgCreateGC (int size);
public static final native void PgDestroyGC (int GC);
public static final native int PgDrawArc (PhPoint_t center, PhPoint_t radii, int start, int end, int flags);
public static final native int PgDrawEllipse (PhPoint_t center, PhPoint_t radii, int flags);
public static final native int PgDrawGradient (PhPoint_t ul, PhPoint_t lr, int gradient_type, int transition_type, int num_color_pts, int color1, int color2, int color3, int color4, int table_size, byte[] transition_table);
public static final native int PgDrawPolygon (short[] ptr, int num, PhPoint_t pos, int flags);
public static final native int PgDrawRoundRect (PhRect_t rect, PhPoint_t radii, int flags);
public static final native int PgDrawILine (int x1, int y1, int x2, int y2);
public static final native int PgDrawIRect (int ulx, int uly, int lrx, int lry, int flags);
//public static final native int PgDrawText (char[] ptr, int len, short x, short y, int flags);
public static final native int PgDrawText (byte[] ptr, int len, short x, short y, int flags);
public static final native int PgDrawMultiTextArea (byte[] text, int len, PhRect_t canvas, int text_flags, int canvas_flags, int linespacing);
public static final native int PgFlush ();
public static final native int PgSetFillColor (int color);
public static final native int PgSetStrokeColor (int color);
public static final native int PgSetTextColor (int color);
public static final native void PgSetFont (byte[] ff);
public static final native int PgSetStrokeDash (byte[] DashList, int ListLen, int DashScale);
public static final native int PgSetStrokeWidth (int width);
public static final native int PgSetDrawMode (int mode);
public static final native int PgSetClipping (short n, int rects);
public static final native int PgSetPalette (int palette, int palette_id, short first_color, short num_colors, int flags, int tag);
public static final native int PgSetGC (int GC);
public static final native void PgSetRegion (int rid);
public static final native int PgSetMultiClip (int num, int clip_list);
//public static final native void PgSetUserClip (int ClipRect);
public static final native void PgSetUserClip (PhRect_t ClipRect);
public static final native int PgDrawImage (int ptr, int type, PhPoint_t pos, PhDim_t size, int bpl, int tag);
public static final native int PgDrawBitmap (int ptr, int flags, PhPoint_t pos, PhDim_t size, int bpl, int tag);
public static final native int PgDrawTImage (int ptr, int type, PhPoint_t pos, PhDim_t size, int bpl, int tag, int TransPtr, int TransBPl);
public static final native int PgDrawPhImageRectmx (PhPoint_t pos, int image, PhRect_t rect, int flags);
public static final native int PhMakeTransBitmap (int image, int trans_color);
public static final native int PiCropImage (int image, PhRect_t bounds, int flags);
public static final native void PhBlit (int rid, PhRect_t rect, PhPoint_t offset);
public static final native int PtClippedBlit (int widget, int src, PhPoint_t delta, int clip);
public static final native int PgSetDrawBufferSize (int cmd_buf_len);

public static final native int PhEventPeek (int buffer, int size);
public static final native int PhEventNext (int buffer, int size);
public static final native int PhGetMsgSize (int event_buf);
public static final native int PhGetTile ();
public static final native int PhAddMergeTiles (int tiles, int add_tiles, int[] added);
public static final native int PhIntersectTilings (int tile1, int tile2, short[] num_intersect_tiles);
public static final native int PhSortTiles (int tiles);
public static final native int PhCoalesceTiles (int tiles);
public static final native int PhMergeTiles (int tiles);
public static final native int PhRectUnion (int rect1, int rect2);
public static final native int PhRectIntersect (int rect1, int rect2);
public static final native int PhTranslateTiles (int tile, PhPoint_t point_add);
public static final native int PhDeTranslateTiles (int tile, int point_subtract);
public static final native int PhClipTilings (int tiles, int clip_tiles, int[] intersection);
public static final native int PhTilesToRects (int tiles, int[] num_rects);
public static final native int PhRectsToTiles (int rects, int num_rects);
public static final native void PhFreeTiles (int tiles);
public static final native int PhWindowQueryVisible (int flag, int rid, int input_group, PhRect_t rect);
//public static final native int PhCreateImage(PhImage_t buffer, short width, short height, int type, int[] palette, int ncolors, int shmem);
public static final native int PhCreateImage(PhImage_t buffer, short width, short height, int type, int palette, int ncolors, int shmem);
public static final native void PhReleaseImage(int image);

public static final native int PmMemCreateMC(int image, PhDim_t dim, PhPoint_t translation);
public static final native void PmMemReleaseMC(int mc);
public static final native int PmMemStart(int mc);
public static final native int PmMemStop(int mc);
public static final native int PmMemFlush(int mc, int image);

public static final native int PtList ();
public static final native int PtLabel ();
public static final native int PtWindow ();
public static final native int PtInit (byte [] name);
public static final native int PtEnter (int flags);
public static final native int PtLeave (int flags);
public static final native int PtCreateWidget (int clazz, int parent, int n_args, int [] args);
public static final native int PtGetResources (int widget, int n_args, int [] args);
public static final native int PtSetResources (int widget, int n_args, int [] args);
public static final native int PtSetResource (int widget, int type, int value, int length);
public static final native int PtRealizeWidget (int widget);
public static final native void PtAddEventHandler (int widget, int event_mask, int callback, int data);
public static final native int PtWidgetRid (int widget);
public static final native void PtMainLoop ();
public static final native int PtEventHandler (int event);
public static final native int PtDestroyWidget (int widget);
public static final native int PtWidgetFlags (int widget);
public static final native int PtWidgetCanvas (int widget, int canvas_rect);
public static final native int PtLabelWidgetCanvas (int widget, PhRect_t canvas_rect);
public static final native int PtWidgetExtent (int widget, int extent);
public static final native int PtWidgetChildBack (int widget);
public static final native boolean PtWidgetIsRealized (int widget);
public static final native int PtWidgetBrotherInFront (int widget);
public static final native int PtWidgetParent (int widget);

public static final native int malloc (int size);
public static final native void free (int ptr);

public static final native void memmove (int address, PhPoint_t point, int size);
public static final native void memmove (PhPoint_t point, int address, int size);

public static final native void memmove (int [] buffer, int address, int size);
public static final native void memmove (int address, int [] buffer, int size);

public static final native void memmove (int address, PhTile_t tile, int size);
public static final native void memmove (PhTile_t tile, int address, int size);

//public static final native void memmove (int address, PtCallbackInfo_t callack, int size);
public static final native void memmove (PtCallbackInfo_t callack, int address, int size);

//public static final native void memmove (int address, PhWindowEvent_t event, int size);
public static final native void memmove (PhWindowEvent_t event, int address, int size);

public static final native void PtAddCallback (int widget, int callback_type, int callback, int data);

public static final native int PtWidgetChildFront (int widget);
public static final native int PtWidgetBrotherBehind (int widget);

public static final native void memmove (byte [] buffer, int address, int size);
public static final native void memmove (int address, byte [] buffer, int size);

public static final native int PtButton ();

public static final native void memmove (int address, PhRect_t rect, int size);
public static final native void memmove (PhRect_t rect, int address, int size);

public static final native int PtUnrealizeWidget (int widget);

public static final native int PtSyncWidget (int widget);
public static final native int PtFlush ();

public static final native int PtContainerGiveFocus (int widget, PhEvent_t event);
public static final native int PtContainerFocusNext (int widget, PhEvent_t event);
public static final native int PtContainerFocusPrev (int widget, PhEvent_t event);
public static final native int PtGlobalFocusNext (int widget, PhEvent_t event);
public static final native int PtGlobalFocusPrev (int widget, PhEvent_t event);
public static final native int PtGlobalFocusNextContainer (int widget, PhEvent_t event);
public static final native int PtGlobalFocusPrevContainer (int widget, PhEvent_t event);

public static final native int PtWidgetToBack (int widget);
public static final native int PtWidgetToFront (int widget);
public static final native int PtWidgetInsert (int widget, int new_sibling, int behind);

public static final native int PtDamageExtent (int widget, PhRect_t extent);

public static final native int PtCreateWidgetClass (int superclass_ref, int size, int num_args, int [] arg);
public static final native void PtSuperClassDraw (int wc_ref, int widget, int damage);

public static final native int PtToggleButton ();
public static final native int PtComboBox ();
public static final native int PtText ();
public static final native int PtMultiText ();
public static final native int PtMenu ();
public static final native int PtMenuBar ();
public static final native int PtMenuButton ();
public static final native int PtScrollbar ();
public static final native int PtSeparator ();

public static final native int PtListAddItems (int widget, int [] items, int item_count, int position);
public static final native void PtListUnselectPos (int widget, int pos);

public static final native void memmove (short [] buffer, int address, int size);
public static final native void memmove (int address, short [] buffer, int size);
public static final native int strlen (int string);
public static final native int strdup (int string);

public static final native int PtListDeleteItemPos (int widget, int item_count, int position);
public static final native int PtListDeleteAllItems (int widget);
public static final native void PtListSelectPos (int widget, int pos);
public static final native int PtListReplaceItemPos (int widget, int [] new_items, int item_count, int position);
public static final native void PtListGotoPos (int widget, int pos);

public static final native int PtTextModifyText (int widget, int start, int end, int insert_pos, byte [] text, int length);
public static final native int PtTextModifyText (int widget, int start, int end, int insert_pos, int text, int length);
public static final native int PtTextGetSelection (int widget, int [] start, int [] end);
public static final native int PtTextSetSelection (int widget, int [] start, int [] end);

public static final native int PtPositionMenu (int widget, PhEvent_t event);
public static final native int PtReParentWidget (int widget, int parent);

public static final native int PtForwardWindowEvent (PhWindowEvent_t event);

public static final native int PtWidgetOffset (int widget, PhPoint_t offset);

public static final native void PtRemoveCallback (int widget, int callback_type, int callback, int data);

public static final native int PtScrollContainer ();

public static final native int PtWidgetCanvas (int widget, PhRect_t canvas_rect);
//public static final native int PtAddClassStyle (int wclass, int style);
public static final native int PtWidgetClass (int widget);
public static final native int PtWidgetIsClassMember (int widget, int clazz);

public static final native void memmove (int dest, int src, int size);

public static final native void memmove (int address, PhImage_t image, int size);
public static final native void memmove (PhImage_t image, int address, int size);

//public static final native void memmove (int address, FontDetails details, int size);
public static final native void memmove (FontDetails details, int address, int size);

public static final native void memmove (int address, PhPointerEvent_t image, int size);
public static final native void memmove (PhPointerEvent_t dest, int src, int size);

public static final native int PhGetData (int event);
public static final native int PhGetRects (int event);

//public static final native void memmove (int address, PhWindowEvent_t event, int size);
public static final native void memmove (PhEvent_t event, int address, int size);
public static final native void memmove (int address, PhEvent_t event, int size);

public static final native int PtExtentWidget (int widget);
public static final native int PtExtentWidgetFamily (int widget);

public static final native void PtGetAbsPosition (int widget, short [] x, short [] y);

//public static final native int PtSetAreaFromExtent (int widget, PhRect_t extent_rect, PhArea_t area);
public static final native int PtSetAreaFromWidgetCanvas (int widget, PhRect_t canvas_rect, PhArea_t area);

//NOT THE SAME
//public static final native int PtSetAreaFromCanvas (int widget, PhRect_t canvas_rect, PhArea_t area);

//public static final native void memmove (int address, PhImage_t image, int size);
public static final native void memmove (PhKeyEvent_t dest, int src, int size);

//public static final native int PhTo8859_1 (int event);
//public static final native int PhKeyToMb (byte [] buffer, int event);

//public static final native void memmove (int dest, PhImage_t src, int size);
public static final native void memmove (PtScrollbarCallback_t dest, int src, int size);

public static final native void memmove (int dest, PhArea_t src, int size);
//public static final native void memmove (PhArea_t dest, int src, int size);

public static final native int PtSetParentWidget (int widget);
public static final native void PtFrameSize (int widget, int border_width, int [] left_border, int [] top_border, int [] right_border, int [] bottom_border);

public static final native int PtCreateAppContext ();
public static final native void PtAppProcessEvent (int app_context);
public static final native int PtAppAddWorkProc (int app_context, int work_func, int data);
public static final native void PtAppRemoveWorkProc (int app_context, int WorkProc_id);

public static final native int PtWidgetExtent (int widget, PhRect_t extent);
public static final native int PtWidgetArea (int widget, PhArea_t area);
public static final native int PhQueryCursor (short ig, PhCursorInfo_t buf);
public static final native int PhInputGroup (int event);

public static final native int PtContainer ();
public static final native int PtDisjoint ();
public static final native int PtScrollArea ();
public static final native int PhCopyTiles (int tile);

public static final native int PtFileSelection (int parent, PhPoint_t pos, byte [] title, byte [] root_dir, byte [] file_spec, byte [] btn1, byte [] btn2, byte [] format, PtFileSelectionInfo_t info, int flags);

public static final native int PtWidgetPreferredSize (int widget, PhDim_t dim);

public static final native int PtAppCreatePulse (int app, int priority);
public static final native int PtAppAddInput (int app_context, int pid, int input_func, int data);
public static final native void PtAppRemoveInput (int app_context, int input_id);
public static final native int PtAppDeletePulse (int app, int pulse_pid);
public static final native int PtAppPulseTrigger (int app, int pulse);

public static final native int PtContainerFindFocus (int family_member);
public static final native int PtIsFocused (int widget);
public static final native int PtWindowFocus (int widget);
public static final native void PtWindowToBack (int widget);
public static final native void PtWindowToFront (int widget);
public static final native int PtFindDisjoint (int widget);
//public static final native int PtFindGuardian( int widget, int superior_only );

public static final native int PtBlockAllWindows(int skip, short cursor, int cursor_color);
public static final native int PtBlockWindow(int window, short cursor, int cursor_color);
public static final native void PtUnblockWindows(int bl);
public static final native int PtNextTopLevelWidget(int widget);
public static final native int PtWindowGetState(int widget);

public static final native void PtAddHotkeyHandler(int widget, int key_sym_cap, int key_mods, short flags, int data, int callback);
public static final native void PtRemoveHotkeyHandler(int widget, int key_sym_cap, int key_mods, short flags, int data, int callback);

public static final native void memmove (PgAlpha_t dest, int src, int size);
public static final native void memmove (int dest, PgAlpha_t src, int size);

public static final native void PgAlphaOn();
public static final native void PgAlphaOff();
//public static final native void PgSetAlpha(int alpha_op, int src_alpha_map, int src_alpha_gradient, byte src_global_alpha, byte dst_global_alpha);
public static final native void PgSetAlpha(int alpha_op, PgMap_t src_alpha_map, int src_alpha_gradient, byte src_global_alpha, byte dst_global_alpha);

public static final native void memmove (PtTextCallback_t dest, int src, int size);
public static final native void memmove (int dest, PtTextCallback_t src, int size);

public static final native int PhInitDrag (int rid, int flags, PhRect_t rect, PhRect_t boundary, int input_group, PhDim_t min, PhDim_t max, PhDim_t step, PhPoint_t ptrpos, short [] cursor);

public static final native int PtProgress ();
public static final native int PtPanelGroup ();

public static final native void PhAreaToRect (PhArea_t area, PhRect_t rect);
public static final native int PtCalcCanvas (int widget, PhRect_t canvas_rect);
public static final native int PtValidParent (int widget_parent, int class_ref);
public static final native void PtCalcBorder (int widget, PhRect_t rect);

public static final native int PtPane ();

public static final native int PtTree ();
public static final native int PtTreeAllocItem (int tree, byte[] str, short set_img, short unset_img);
public static final native int PtTreeModifyItem (int tree, int item, byte[] str, short set_img, short unset_img);
public static final native int PtTreeModifyItemString (int tree, int item, byte[] string);
public static final native int PtTreeFreeItems (int items);
public static final native int PtTreeAddFirst (int tree, int item, int parent);
public static final native int PtTreeAddAfter (int tree, int item, int brother);
public static final native int PtTreeExpand (int tree, int item, int event);
public static final native int PtTreeCollapse (int tree, int item, int event);
public static final native void PtTreeRemoveItem (int tree, int item);
public static final native void PtTreeFreeAllItems (int tree);
public static final native int PtTreeRootItem (int tree);
public static final native void PtTreeClearSelection (int tree);
public static final native void PtTreeSelect (int tree, int item);
public static final native int PtTreeSetSelIndexes (int widget, int []buffer, int count );
public static final native int PtTreeSelectedItems (int widget, int buffer);

public static final native void memmove (PtTreeItem_t dest, int src, int size);
public static final native void memmove (int dest, PtTreeItem_t src, int size);

public static final native void memmove (PgMap_t dest, int src, int size);
public static final native void memmove (int dest, PgMap_t src, int size);

public static final native int PtDamageWidget (int widget);
public static final native int PtBlit (int widget, PhRect_t source, PhPoint_t delta);
public static final native int PtContainerHold (int container_widget);
public static final native int PtContainerRelease (int container_widget);

public static final native int PtFontSelection (int parent, PhPoint_t pos, byte[] title, byte[] font, int symbol, int flags, byte[] sample);

public static final native int PtToolbar ();

//public static final native int PtColorSelGroup ();
//public static final native int PtColorPatch ();
//public static final native int PtColorPalette ();

public static final native int PtGroup ();

//public static final native int Pg_CM_RGB ();
//public static final native int Pg_CM_HSB ();
//public static final native int Pg_CM_HLS ();

public static final native int PhRectUnion (PhRect_t rect1, PhRect_t rect2);
public static final native int PtRegion ();
public static final native void PtAddFilterCallback (int widget, int event_mask, int callback, int data);

public static final native int PtListItemPos (int widget, byte[] item);

public static final native int PtTimer ();
public static final native int PtHit (int container, int n, PhRect_t rect);

public static final native int PtColorSelect (int parent, byte[] title, PtColorSelectInfo_t info);

public static final native void PgDrawArrow (PhRect_t rect, short unknown, int color, int flags);

public static final native int PtBeep ();

public static final native int PtAlert (int parent, PhPoint_t location, byte[] title, int image, byte[] message, byte[] msgFont, int btnCount, int[] buttons, int[] btnFonts, int defBtn, int escBtn, int flags);

public static final native int PtSlider ();

public static final native int PiDuplicateImage (int image, int flags);

public static final native int PhMakeGhostBitmap (int image);

public static final native int PgReadScreen (PhRect_t rect, int buffer);
public static final native int PgReadScreenSize (PhRect_t rect);
public static final native int PgShmemCreate (int size, byte[] name);
//public static final native int PgShmemDetach (int addr);
public static final native int PgShmemDestroy (int addr);
//public static final native void PgShmemCleanup ();
public static final native int PhRegionQuery (int rid, PhRegion_t region, PhRect_t rect, int data, int data_len);
//public static final native int PiGetPixelRGB (int image, short x, short y, int[] value);

public static final native void memmove (PtContainerCallback_t dest, int src, int size);
//public static final native void memmove (int dest, PtContainerCallback_t src, int size);

public static final native void PtSendEventToWidget (int widget, int event);

//public static final native void memmove (PhCursorDef_t dest, int src, int size);
public static final native void memmove (int dest, PhCursorDef_t src, int size);

public static final native void PgSetFillTransPat (byte [] pat);

public static final native int PtInflateBalloon (int win, int me, int position, byte [] string, byte [] font, int fill, int text_color);

//public static final native void memmove (PgDisplaySettings_t dest, int src, int size);
//public static final native void memmove (int dest, PgDisplaySettings_t src, int size);

//public static final native void memmove (PgVideoModeInfo_t dest, int src, int size);
//public static final native void memmove (int dest, PgVideoModeInfo_t src, int size);

public static final native int PgGetVideoMode (PgDisplaySettings_t settings);
public static final native int PgGetVideoModeInfo (short mode_number, PgVideoModeInfo_t mode_info);

public static final native void memmove (PhClipHeader dest, int src, int size);
public static final native void memmove (int dest, PhClipHeader src, int size);
public static final native void memmove (byte[] dest, PhClipHeader src, int size);

public static final native int PhClipboardCopyString (short ig, byte [] string);
public static final native int PhClipboardPasteString (short ig);
public static final native int PhClipboardCopy (short ig, int n, byte[] clip);
public static final native int PhClipboardPasteStart (short ig);
public static final native int PhClipboardPasteType (int cbdata, byte[] type);
public static final native int PhClipboardPasteTypeN (int cbdata, int n);
public static final native void PhClipboardPasteFinish (int cbdata);
public static final native int PtHold ();
public static final native int PtRelease ();

//public static final native void memmove (int dest, PtTreeCallback_t src, int size);
public static final native void memmove (PtTreeCallback_t dest, int src, int size);
public static final native int PtTreeShow(int widget, int item );
public static final native void PhMoveCursorAbs (int input_group, int x, int y );
public static final native int getenv(byte[] name);
public static final native int PhDCSetCurrent(int draw_context);
}
